/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb2.model;

import com.dbeaver.ee.influxdb2.FluxUtils;
import com.dbeaver.ee.influxdb2.exec.Influx2ResultSet;
import com.dbeaver.ee.influxdb2.exec.Influx2SelectStatement;
import com.dbeaver.ee.influxdb2.exec.Influx2Session;
import com.dbeaver.ee.influxdb2.model.Influx2DataType;
import com.dbeaver.ee.influxdb2.model.Influx2Measurement;
import com.influxdb.client.InfluxDBClient;
import com.influxdb.query.FluxTable;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.utils.CommonUtils;

public class Influx2MeasurementField
implements DBSTableColumn,
DBSTypedObjectEx,
DBSDataContainer {
    private static final Log log = Log.getLog(Influx2MeasurementField.class);
    private final Influx2Measurement table;
    private final String name;
    private final int position;
    private final Influx2DataType dataType;

    public Influx2MeasurementField(Influx2Measurement table, int position, String name, Influx2DataType dataType) {
        this.table = table;
        this.position = position;
        this.name = name;
        this.dataType = dataType;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.table.getDataSource();
    }

    @NotNull
    public String[] getSupportedFeatures() {
        return this.getParentObject().getSupportedFeatures();
    }

    @NotNull
    public DBCStatistics readData(@Nullable DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, @Nullable DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBException {
        DBCStatistics statistics;
        block20: {
            Influx2Session influxSession = (Influx2Session)session;
            statistics = new DBCStatistics();
            StringBuilder query = new StringBuilder();
            try {
                this.appendQuery(dataFilter, query, maxRows);
            }
            catch (DBException e) {
                throw new DBCException("Can't generate query conditions", (Throwable)e, session.getExecutionContext());
            }
            SQLUtils.appendQueryOrder((DBPDataSource)this.getDataSource(), (StringBuilder)query, null, (DBDDataFilter)dataFilter);
            Throwable throwable = null;
            Object var16_15 = null;
            try (Influx2SelectStatement statement = new Influx2SelectStatement(influxSession, this.getParentObject().getDatabase(), query.toString());){
                statement.setStatementSource(source);
                statement.setLimit(firstRow, maxRows);
                statistics.setQueryText(statement.getQueryString());
                statistics.addStatementsCount();
                if (!statement.executeStatement()) break block20;
                Throwable throwable2 = null;
                Object var19_20 = null;
                try (Influx2ResultSet resultSet = statement.openResultSet();){
                    DBDDataReceiver.startFetchWorkflow((DBDDataReceiver)dataReceiver, (DBCSession)influxSession, (DBCResultSet)resultSet, (long)firstRow, (long)maxRows);
                    DBDDataReceiver.fetchRowsWithStatistics((DBDDataReceiver)dataReceiver, (DBCSession)session, (DBCResultSet)resultSet, (DBCStatistics)statistics);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        return statistics;
    }

    private void appendQuery(@Nullable DBDDataFilter dataFilter, @NotNull StringBuilder query, long maxRows) throws DBException {
        query.append("from(bucket: ").append("\"").append(this.getParentObject().getParentObject()).append("\")");
        query.append("\n|> range(start: 0)");
        query.append("\n|> filter(fn: (r) => r._measurement == ").append("\"").append(this.getParentObject().getName()).append("\")");
        query.append("\n|> filter(fn: (r) => r._field == ").append("\"").append(this.getName()).append("\")");
        SQLUtils.appendQueryConditions((DBPDataSource)this.getDataSource(), (StringBuilder)query, null, (DBDDataFilter)dataFilter);
        if (maxRows != -1L) {
            FluxUtils.appendLimitInfo(query, maxRows);
        }
        query.append("\n|> group()");
    }

    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) throws DBCException {
        List influxQLQueryResult;
        block3: {
            try {
                StringBuilder query = new StringBuilder();
                this.appendQuery(dataFilter, query, -1L);
                query.append("\n|> count()");
                Influx2Session influxSession = (Influx2Session)session;
                InfluxDBClient influxDB = influxSession.getClient();
                influxQLQueryResult = influxDB.getQueryApi().query(query.toString());
                if (!CommonUtils.isEmpty((Collection)influxQLQueryResult)) break block3;
                return -1L;
            }
            catch (Throwable e) {
                throw new DBCException(e, session.getExecutionContext());
            }
        }
        return CommonUtils.toLong(((FluxTable)influxQLQueryResult.get(0)).getRecords().get(0), (long)-1L);
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean isPersisted() {
        return true;
    }

    @Property(viewable=true, editable=true, order=2)
    public int getOrdinalPosition() {
        return this.position;
    }

    public int getTypeID() {
        return this.dataType.getTypeID();
    }

    @NotNull
    public DBPDataKind getDataKind() {
        return this.dataType.getDataKind();
    }

    @Property(viewable=true, editable=true, order=3)
    @NotNull
    public String getTypeName() {
        return this.dataType.getTypeName();
    }

    @NotNull
    public String getFullTypeName() {
        return this.dataType.getFullTypeName();
    }

    public boolean isRequired() {
        return false;
    }

    public boolean isAutoGenerated() {
        return false;
    }

    @NotNull
    public Influx2Measurement getParentObject() {
        return this.table;
    }

    public String getDefaultValue() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    @Nullable
    public Integer getScale() {
        return 0;
    }

    @Nullable
    public Integer getPrecision() {
        return 0;
    }

    public long getMaxLength() {
        return 0L;
    }

    public long getTypeModifiers() {
        return 0L;
    }

    public String toString() {
        return this.name;
    }

    public Influx2DataType getDataType() {
        return this.dataType;
    }
}

