/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb2.exec;

import com.dbeaver.ee.influxdb2.exec.Influx2ResultSet;
import com.dbeaver.ee.influxdb2.exec.Influx2Session;
import com.dbeaver.ee.influxdb2.model.Influx2Database;
import com.influxdb.query.FluxTable;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.AbstractStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public abstract class Influx2BaseStatement
extends AbstractStatement<Influx2Session> {
    protected final Influx2Database database;
    protected final String query;
    protected DBCExecutionSource source;
    protected List<FluxTable> queryResult;
    protected int curResultsIndex;
    protected int curSeriesIndex;
    protected Throwable executeError;
    protected int offset;
    protected int limit;
    private String tableName;

    protected Influx2BaseStatement(Influx2Session session, Influx2Database database, String query) {
        super((DBCSession)session);
        this.database = database;
        this.query = query;
        if (((Influx2Session)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementOpen((DBCStatement)this);
        }
    }

    public Influx2Database getCurrentDatabase() {
        return this.database != null ? this.database : ((Influx2Session)this.getSession()).getExecutionContext().getDefaultCatalog();
    }

    public String getQueryString() {
        return this.query;
    }

    public DBCExecutionSource getStatementSource() {
        return this.source;
    }

    public void setStatementSource(@Nullable DBCExecutionSource source) {
        this.source = source;
    }

    public Influx2ResultSet openResultSet() throws DBCException {
        return new Influx2ResultSet(this, this.queryResult.get(this.curResultsIndex));
    }

    public long getUpdateRowCount() {
        return -1L;
    }

    public boolean nextResults() throws DBCException {
        FluxTable table;
        if (this.queryResult.size() - 1 > this.curResultsIndex && (table = this.queryResult.get(this.curResultsIndex)) != null) {
            ++this.curResultsIndex;
            return true;
        }
        return false;
    }

    public void setLimit(long offset, long limit) throws DBCException {
        this.offset = (int)offset;
        this.limit = (int)limit;
    }

    @Nullable
    public Throwable[] getStatementWarnings() throws DBCException {
        return null;
    }

    public void setStatementTimeout(int timeout) throws DBCException {
    }

    public void setResultsFetchSize(int fetchSize) throws DBCException {
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        if (blockThread == null) {
            throw new DBCFeatureNotSupportedException();
        }
        blockThread.interrupt();
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    protected DBCException handleExecuteError(Throwable ex) {
        this.executeError = ex;
        if (ex instanceof DBCException) {
            return (DBCException)ex;
        }
        return new DBCException(ex, (DBCExecutionContext)((Influx2Session)this.getSession()).getExecutionContext());
    }

    protected void beforeExecute() {
        this.executeError = null;
        if (((Influx2Session)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        this.startBlock();
    }

    protected void afterExecute() {
        this.endBlock();
        if (((Influx2Session)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, this.getUpdateRowCount(), this.executeError);
        }
    }

    protected void startBlock() {
        ((Influx2Session)this.getSession()).getProgressMonitor().startBlock((DBRBlockingObject)this, ((Object)((Object)this)).getClass().getSimpleName());
    }

    protected void endBlock() {
        ((Influx2Session)this.getSession()).getProgressMonitor().endBlock();
    }

    protected void setTableName(String tableName) {
        this.tableName = tableName;
    }

    protected void setQueryResult(List<FluxTable> queryResult) {
        this.queryResult = queryResult;
    }
}

