/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb2;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLQueryGenerator;
import org.jkiss.utils.CommonUtils;

public class FluxDialectQueryGenerator
implements SQLQueryGenerator {
    private static final Log log = Log.getLog(FluxDialectQueryGenerator.class);
    public static FluxDialectQueryGenerator INSTANCE = new FluxDialectQueryGenerator();

    public void appendQueryConditions(@NotNull DBPDataSource dataSource, @NotNull StringBuilder query, @Nullable String tableAlias, @Nullable DBDDataFilter dataFilter) throws DBException {
        if (dataFilter != null && dataFilter.hasConditions()) {
            query.append("\n|> filter(fn: (r) => ");
            this.appendConditionString(dataFilter, dataSource, tableAlias, query, true);
            query.append(")");
        }
    }

    public void appendQueryOrder(@NotNull DBPDataSource dataSource, @NotNull StringBuilder query, @Nullable String tableAlias, @Nullable DBDDataFilter dataFilter) {
        if (dataFilter != null && dataFilter.hasOrdering()) {
            this.appendOrderString(dataFilter, dataSource, tableAlias, false, query);
        }
    }

    @NotNull
    public String getQueryWithAppliedFilters(@Nullable DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull String sqlQuery, @NotNull DBDDataFilter dataFilter) throws DBException {
        return this.getWrappedFilterQuery(dataSource, sqlQuery, dataFilter);
    }

    @NotNull
    public String getWrappedFilterQuery(@NotNull DBPDataSource dataSource, @NotNull String sqlQuery, @NotNull DBDDataFilter dataFilter) throws DBException {
        StringBuilder modifiedQuery = new StringBuilder(sqlQuery.length() + 100);
        modifiedQuery.append(sqlQuery);
        if (dataFilter.hasConditions()) {
            this.appendQueryConditions(dataSource, modifiedQuery, null, dataFilter);
        }
        if (dataFilter.hasOrdering()) {
            this.appendQueryOrder(dataSource, modifiedQuery, null, dataFilter);
        }
        return modifiedQuery.toString();
    }

    public void appendConditionString(@NotNull DBDDataFilter filter, @NotNull List<DBDAttributeConstraint> constraints, @NotNull DBPDataSource dataSource, @Nullable String conditionTable, @NotNull StringBuilder query, boolean inlineCriteria, boolean subQuery) throws DBException {
        if (filter.isUseDisjunctiveNormalForm() && constraints.size() > 1) {
            throw new DBException("Generation of a condition in a disjunctive normal form is not supported yet");
        }
        String operator = filter.isAnyConstraint() ? " or " : " and ";
        int index = 0;
        while (index < constraints.size()) {
            DBDAttributeConstraint constraint = constraints.get(index);
            if (index > 0) {
                query.append(operator);
            }
            if (constraints.size() > 1) {
                query.append('(');
            }
            query.append(this.getConstraintCondition(dataSource, constraint, conditionTable, inlineCriteria));
            if (constraints.size() > 1) {
                query.append(')');
            }
            ++index;
        }
        if (!CommonUtils.isEmpty((String)filter.getWhere())) {
            if (constraints.size() > 0) {
                query.append(operator).append('(').append(filter.getWhere()).append(')');
            } else {
                query.append(filter.getWhere());
            }
        }
    }

    public void appendOrderString(@NotNull DBDDataFilter filter, @NotNull DBPDataSource dataSource, @Nullable String conditionTable, boolean subQuery, @NotNull StringBuilder query) {
        Stack operations = new Stack();
        boolean isDesc = false;
        String name = null;
        ArrayList<String> columns = null;
        for (DBDAttributeConstraint orderConstraint : filter.getOrderConstraints()) {
            if (name == null || orderConstraint.isOrderDescending() != isDesc) {
                if (columns != null) {
                    operations.add(columns);
                }
                columns = new ArrayList<String>();
                isDesc = orderConstraint.isOrderDescending();
            }
            name = orderConstraint.getAttributeName();
            columns.add(name);
        }
        if (columns != null) {
            operations.add(columns);
        }
        while (!operations.empty()) {
            query.append("\n|> sort(columns: [");
            List peek = (List)operations.pop();
            int i = 0;
            while (i < peek.size()) {
                if (i != 0) {
                    query.append(", ");
                }
                query.append("\"").append((String)peek.get(i)).append("\"");
                ++i;
            }
            query.append("]");
            if (!isDesc) {
                query.append(", desc: true");
            }
            query.append(")");
            boolean bl = isDesc = !isDesc;
        }
    }

    @Nullable
    public String getConstraintCondition(@NotNull DBPDataSource dataSource, @NotNull DBDAttributeConstraint constraint, @Nullable String conditionTable, boolean inlineCriteria) {
        if (constraint.getOperator() != null) {
            DBCLogicalOperator operator = constraint.getOperator();
            StringBuilder conString = new StringBuilder();
            Object value = constraint.getValue();
            if (DBUtils.isNullValue((Object)value)) {
                if (!constraint.isReverseOperator()) {
                    conString.append(" not");
                }
                conString.append(" exists");
                conString.append(" r.").append(constraint.getAttributeName());
                return conString.toString();
            }
            if (constraint.isReverseOperator()) {
                conString.append(" not ");
            }
            if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                int i = 0;
                while (i < array.length) {
                    if (i > 0) {
                        conString.append(" or ");
                    }
                    this.addCondition(constraint, operator, conString, array[i]);
                    ++i;
                }
            } else {
                this.addCondition(constraint, operator, conString, value);
            }
            return conString.toString();
        }
        return null;
    }

    private void addCondition(@NotNull DBDAttributeConstraint constraint, DBCLogicalOperator operator, StringBuilder conString, Object value) {
        conString.append("r.").append(constraint.getAttributeName()).append(" ");
        String expression = operator.getExpression();
        expression = expression.replace("=", "==");
        expression = expression.replace("<>", "!=");
        conString.append(expression).append(" ");
        conString.append(FluxDialectQueryGenerator.getStringValue(value));
    }

    private static String getStringValue(Object value) {
        Object strValue = "";
        strValue = value instanceof Double ? "float(v: \"" + String.valueOf(value) + "\")" : (value instanceof Instant ? "time(v: " + String.valueOf(value) + ")" : (value instanceof CharSequence ? "\"" + String.valueOf(value) + "\"" : CommonUtils.toString((Object)value)));
        return strValue;
    }

    private FluxDialectQueryGenerator() {
    }
}

