/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.chart.ui.resultset;

import com.dbeaver.ee.chart.UIChartsMessagesPro;
import com.dbeaver.ee.chart.model.ChartMeasurement;
import com.dbeaver.ee.chart.model.ChartSampleFunction;
import com.dbeaver.ee.chart.model.ChartType;
import com.dbeaver.ee.chart.ui.resultset.ResultsChartPresentation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolTip;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.editors.object.struct.EditDictionaryPage;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.utils.CommonUtils;

class ResultsChartConfigDialog
extends BaseDialog {
    private static final String DIALOG_ID = "DBeaver.ResultsChartConfigDialog";
    private final String HELP_CHART_MANAGEMENT_LINK = "Managing-Charts";
    private final ResultsChartPresentation presentation;
    private CTabFolder chartTabFolder;

    ResultsChartConfigDialog(ResultsChartPresentation presentation) {
        super(presentation.getControl().getShell(), "Charts for [" + presentation.getController().getDataContainer().getName() + "]", null);
        this.presentation = presentation;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        this.chartTabFolder = new CTabFolder(composite, 0x800082);
        this.chartTabFolder.setLayoutData((Object)new GridData(1808));
        ArrayList<ChartMeasurement> measurements = new ArrayList<ChartMeasurement>(this.presentation.getMeasurements());
        if (measurements.isEmpty()) {
            measurements.add(this.presentation.createEmptyMeasurement());
        }
        int i = 0;
        while (i < measurements.size()) {
            this.createChartTab(this.chartTabFolder, i, (ChartMeasurement)measurements.get(i));
            ++i;
        }
        this.chartTabFolder.setSelection(0);
        return parent;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.updateControls();
        return contents;
    }

    private CTabItem createChartTab(CTabFolder chartTabFolder, int index, ChartMeasurement measurement) {
        CTabItem item = new CTabItem(chartTabFolder, 0);
        item.setText("Chart " + (index + 1));
        item.setData((Object)measurement);
        item.setControl((Control)this.createMeasurementEditor(chartTabFolder, measurement));
        return item;
    }

    private Composite createMeasurementEditor(final CTabFolder tabFolder, final ChartMeasurement measurement) {
        Composite group = new Composite((Composite)tabFolder, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        Group axisXGroup = UIUtils.createControlGroup((Composite)group, (String)"Axis X", (int)2, (int)768, (int)-1);
        final Combo domainColumnCombo = this.createColumnsCombo((Composite)axisXGroup, measurement.getGroupAttributes(), measurement.getTitleX(), false);
        this.createXAxisOrderToolbar((Composite)axisXGroup, measurement);
        Composite dictComposite = UIUtils.createComposite((Composite)axisXGroup, (int)2);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        dictComposite.setLayoutData((Object)gd);
        final Button useDictionaryCheck = UIUtils.createCheckbox((Composite)dictComposite, (String)"Use dictionary", (String)"Use dictionary values instead of plain numeric value", (boolean)measurement.isUseDictionaries(), (int)1);
        useDictionaryCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                measurement.setUseDictionaries(useDictionaryCheck.getSelection());
            }
        });
        Link dictLink = UIUtils.createLink((Composite)dictComposite, (String)"<a>Edit Dictionary</a>", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBSEntity refEntity;
                DBSEntityReferrer constraint;
                DBDAttributeBinding attr = ResultsChartConfigDialog.this.getAttributeByNames(domainColumnCombo.getText());
                if (attr != null && (constraint = ResultSetUtils.getEnumerableConstraint((DBDAttributeBinding)attr)) instanceof DBSEntityAssociation && (refEntity = ResultSetUtils.getAssociatedEntity((DBSEntityConstraint)constraint)) != null) {
                    EditDictionaryPage editDictionaryPage = new EditDictionaryPage(refEntity);
                    editDictionaryPage.edit(tabFolder.getShell());
                }
            }
        });
        dictLink.setLayoutData((Object)new GridData(768));
        UIUtils.createInfoLabel((Composite)axisXGroup, (String)"Choose unique columns for X (domain) axis", (int)768, (int)2);
        Runnable dictEnabler = () -> {
            DBSEntity associatedEntity;
            DBDAttributeBinding attr = this.getAttributeByNames(domainColumnCombo.getText());
            DBSEntityReferrer constraint = null;
            if (attr != null) {
                constraint = ResultSetUtils.getEnumerableConstraint((DBDAttributeBinding)attr);
            }
            useDictionaryCheck.setEnabled(constraint != null);
            dictLink.setEnabled(constraint != null);
            Object linkText = "<a>Edit Dictionary</a>";
            if (constraint != null && (associatedEntity = ResultSetUtils.getAssociatedEntity((DBSEntityConstraint)constraint)) != null) {
                linkText = (String)linkText + "  (" + associatedEntity.getName() + ")";
            }
            dictLink.setText((String)linkText);
        };
        domainColumnCombo.addModifyListener(e -> dictEnabler.run());
        dictEnabler.run();
        Group axisYGroup = UIUtils.createControlGroup((Composite)group, (String)"Axis Y", (int)2, (int)768, (int)-1);
        Combo valueColumnCombo = this.createColumnsCombo((Composite)axisYGroup, measurement.getValueAttribute() == null ? Collections.emptyList() : Collections.singletonList(measurement.getValueAttribute()), measurement.getTitleY(), true);
        this.createYAxisOrderToolbar((Composite)axisYGroup, measurement);
        Composite regexPanel = UIUtils.createComposite((Composite)axisYGroup, (int)3);
        regexPanel.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
        final Button recognizeNumbersWithRegexChk = UIUtils.createCheckbox((Composite)regexPanel, (String)"Parse value with regex", (boolean)false);
        recognizeNumbersWithRegexChk.setSelection(measurement.getValueRegex() != null);
        final Text regexText = new Text(regexPanel, 2048);
        regexText.setLayoutData((Object)new GridData(768));
        regexText.setText(CommonUtils.toString((Object)measurement.getValueRegex(), (String)""));
        regexText.setEnabled(measurement.getValueRegex() != null);
        ToolTip regexErrorToolTip = new ToolTip(regexText.getShell(), 4096);
        regexErrorToolTip.setAutoHide(false);
        final Consumer<Boolean> showRegexErrorToolTip22 = show -> {
            if (regexText.getToolTipText() != null && Boolean.TRUE.equals(show)) {
                regexErrorToolTip.setMessage(regexText.getToolTipText());
                regexErrorToolTip.setLocation(regexText.getShell().toDisplay(regexText.getShell().getDisplay().map((Control)regexText, (Control)regexText.getShell(), 0, text.getSize().y)));
                regexErrorToolTip.setVisible(true);
            } else {
                regexErrorToolTip.setVisible(false);
            }
        };
        regexText.addModifyListener(e -> {
            try {
                measurement.setValueRegex(regexText.getText());
                regexText.setToolTipText(null);
                regexText.setBackground(null);
            }
            catch (PatternSyntaxException ex) {
                regexText.setToolTipText(ex.getMessage());
                regexText.setBackground(new Color(255, 220, 220));
            }
            showRegexErrorToolTip22.accept(true);
            regexText.redraw();
        });
        regexText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                showRegexErrorToolTip22.accept(false);
            }

            public void focusGained(FocusEvent e) {
                showRegexErrorToolTip22.accept(true);
            }
        });
        recognizeNumbersWithRegexChk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                regexText.setEnabled(recognizeNumbersWithRegexChk.getSelection());
                measurement.setValueRegex(null);
            }
        });
        UIUtils.createInfoLabel((Composite)axisYGroup, (String)"Only numeric and string columns can be used for Y (value) axis\nUse named group \"...(?<value>...)...\" to parse value with nontrivial pattern", (int)768, (int)2);
        Group optionsGroup = UIUtils.createControlGroup((Composite)group, (String)"Options", (int)4, (int)768, (int)-1);
        Text sampleCountText = UIUtils.createLabelText((Composite)optionsGroup, (String)"Sample count", (String)String.valueOf(measurement.getMaxSampleCount()));
        sampleCountText.setToolTipText(UIChartsMessagesPro.chart_settings_sample_count_tooltip);
        sampleCountText.addModifyListener(e -> measurement.setMaxSampleCount(CommonUtils.toInt((Object)sampleCountText.getText(), (int)0)));
        Text rowCountText = UIUtils.createLabelText((Composite)optionsGroup, (String)"Row count", (String)(measurement.getMaxRowCount() <= 0 ? "" : String.valueOf(measurement.getMaxRowCount())));
        rowCountText.setToolTipText(UIChartsMessagesPro.chart_settings_row_count_tooltip);
        rowCountText.addModifyListener(e -> measurement.setMaxRowCount(CommonUtils.toInt((Object)rowCountText.getText(), (int)0)));
        Combo sampleFuncCombo = UIUtils.createLabelCombo((Composite)optionsGroup, (String)"Sample function", (String)"This function will be used to produce cumulative value (if domain value is not unique)", (int)12);
        ChartSampleFunction[] chartSampleFunctionArray = ChartSampleFunction.values();
        int n = chartSampleFunctionArray.length;
        int showRegexErrorToolTip22 = 0;
        while (showRegexErrorToolTip22 < n) {
            ChartSampleFunction f = chartSampleFunctionArray[showRegexErrorToolTip22];
            sampleFuncCombo.add(f.name());
            ++showRegexErrorToolTip22;
        }
        sampleFuncCombo.setText(measurement.getSampleFunction().name());
        sampleFuncCombo.addModifyListener(e -> measurement.setSampleFunction(ChartSampleFunction.valueOf(sampleFuncCombo.getText())));
        Combo chartTypeCombo = UIUtils.createLabelCombo((Composite)optionsGroup, (String)"Chart Type", (int)12);
        ChartType[] chartTypeArray = ChartType.values();
        int n2 = chartTypeArray.length;
        n = 0;
        while (n < n2) {
            ChartType type = chartTypeArray[n];
            chartTypeCombo.add(type.getLabel());
            ++n;
        }
        chartTypeCombo.select(measurement.getChartType().ordinal());
        chartTypeCombo.addModifyListener(e -> measurement.setChartType(ChartType.values()[chartTypeCombo.getSelectionIndex()]));
        Composite composite = new Composite(group, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        Label imageLabel = new Label(composite, 0);
        imageLabel.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.SMALL_INFO));
        UIUtils.createLink((Composite)composite, (String)("For additional information see: <a href=\"" + HelpUtils.getHelpExternalReference((String)"Managing-Charts") + "\">Managing Charts</a>"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"Managing-Charts"));
            }
        });
        domainColumnCombo.addModifyListener(e -> {
            if (CommonUtils.equalObjects((Object)valueColumnCombo.getText(), (Object)domainColumnCombo.getText())) {
                valueColumnCombo.setText("");
            }
            measurement.setGroupAttributes(this.getAttributesByNames(domainColumnCombo.getText()));
            this.updateControls();
        });
        ((Text)domainColumnCombo.getData("label")).addModifyListener(e -> {
            measurement.setTitleX(((Text)e.widget).getText());
            this.updateControls();
        });
        valueColumnCombo.addModifyListener(e -> {
            if (CommonUtils.equalObjects((Object)domainColumnCombo.getText(), (Object)valueColumnCombo.getText())) {
                domainColumnCombo.setText("");
            }
            measurement.setValueAttribute(this.getAttributeByNames(valueColumnCombo.getText()));
            this.updateControls();
        });
        ((Text)valueColumnCombo.getData("label")).addModifyListener(e -> {
            measurement.setTitleY(((Text)e.widget).getText());
            this.updateControls();
        });
        return group;
    }

    private List<DBDAttributeBinding> getAttributesByNames(String text) {
        ArrayList<DBDAttributeBinding> result = new ArrayList<DBDAttributeBinding>();
        String[] stringArray = text.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attrName = stringArray[n2];
            attrName = attrName.trim();
            DBDAttributeBinding attributeBinding = (DBDAttributeBinding)DBUtils.findObject((Collection)this.presentation.getController().getModel().getVisibleAttributes(), (String)attrName);
            if (attributeBinding != null) {
                result.add(attributeBinding);
            }
            ++n2;
        }
        return result;
    }

    private DBDAttributeBinding getAttributeByNames(String text) {
        return (DBDAttributeBinding)DBUtils.findObject((Collection)this.presentation.getController().getModel().getVisibleAttributes(), (String)text);
    }

    private Combo createColumnsCombo(Composite parent, List<DBDAttributeBinding> selection, String label, boolean numberOrString) {
        Combo combo = UIUtils.createLabelCombo((Composite)parent, (String)"Column", (int)12);
        combo.setLayoutData((Object)new GridData(768));
        combo.add("");
        List attributes = this.presentation.getController().getModel().getVisibleAttributes();
        for (DBDAttributeBinding attr : attributes) {
            if (numberOrString && attr.getDataKind() != DBPDataKind.NUMERIC && attr.getDataKind() != DBPDataKind.STRING) continue;
            combo.add(attr.getName());
        }
        StringBuilder selName = new StringBuilder();
        for (DBSAttributeBase dBSAttributeBase : selection) {
            if (!selName.isEmpty()) {
                selName.append(", ");
            }
            selName.append(dBSAttributeBase.getName());
        }
        combo.setText(selName.toString());
        Text text = UIUtils.createLabelText((Composite)parent, (String)"Label", (String)"", (int)2048);
        text.setLayoutData((Object)new GridData(768));
        combo.setData("label", (Object)text);
        if (label != null) {
            text.setText(label);
        }
        combo.addModifyListener(e -> labelText.setText(combo.getText()));
        return combo;
    }

    @NotNull
    private Composite createXAxisOrderToolbar(@NotNull Composite parent, @NotNull ChartMeasurement measurement) {
        return this.createAxisOrderToolbar(parent, measurement, ChartMeasurement::getAxisOrderX, measurement::setAxisOrderX);
    }

    @NotNull
    private Composite createYAxisOrderToolbar(@NotNull Composite parent, @NotNull ChartMeasurement measurement) {
        return this.createAxisOrderToolbar(parent, measurement, ChartMeasurement::getAxisOrderY, measurement::setAxisOrderY);
    }

    @NotNull
    private Composite createAxisOrderToolbar(@NotNull Composite parent, @NotNull ChartMeasurement measurement, @NotNull Function<ChartMeasurement, IResultSetController.ColumnOrder> getOrderFunc, @NotNull Consumer<IResultSetController.ColumnOrder> setOrderConsumer) {
        Combo orderCombo = UIUtils.createLabelCombo((Composite)parent, (String)ResultSetMessages.controls_resultset_filter_column_order, (int)12);
        orderCombo.setLayoutData((Object)new GridData(768));
        Arrays.stream(IResultSetController.ColumnOrder.values()).forEach(co -> orderCombo.add(co.getText(), co.ordinal()));
        orderCombo.select(getOrderFunc.apply(measurement).ordinal());
        orderCombo.addModifyListener(e -> {
            IResultSetController.ColumnOrder order = (IResultSetController.ColumnOrder)CommonUtils.fromOrdinal(IResultSetController.ColumnOrder.class, (int)orderCombo.getSelectionIndex());
            setOrderConsumer.accept(order);
        });
        orderCombo.setToolTipText(UIChartsMessagesPro.chart_settings_sorting_order_tooltip);
        return orderCombo;
    }

    private boolean isValid() {
        CTabItem[] cTabItemArray = this.chartTabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            ChartMeasurement measurement = (ChartMeasurement)item.getData();
            if (CommonUtils.isEmpty((String)measurement.getTitleY()) || CommonUtils.isEmpty((String)measurement.getTitleX()) || measurement.getGroupAttributes().isEmpty() || measurement.getValueAttribute() == null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void updateControls() {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(this.isValid());
        }
    }

    protected void okPressed() {
        ArrayList<ChartMeasurement> measurements = new ArrayList<ChartMeasurement>();
        CTabItem[] cTabItemArray = this.chartTabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            ChartMeasurement measurement = (ChartMeasurement)item.getData();
            measurement.loadDataFromModel((DBRProgressMonitor)new VoidProgressMonitor(), this.presentation.getController());
            measurements.add(measurement);
            ++n2;
        }
        this.presentation.setMeasurements(measurements);
        this.presentation.refreshData(false, false, true);
        super.okPressed();
    }
}

