/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.truncate;

import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.ext.ora.truncate.TruncateStatement;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class TruncateGenerator
extends AbstractSqlGenerator<TruncateStatement> {
    public boolean supports(TruncateStatement truncateStatement, Database database) {
        return database instanceof OracleDatabase;
    }

    public ValidationErrors validate(TruncateStatement truncateStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        boolean noCluster;
        ValidationErrors errors = new ValidationErrors();
        boolean noTable = truncateStatement.getTableName() == null || truncateStatement.getTableName().length() == 0;
        boolean bl = noCluster = truncateStatement.getClusterName() == null || truncateStatement.getClusterName().length() == 0;
        if (noTable == noCluster) {
            errors.addError("Either tableName or clusterName must be set");
        }
        return errors;
    }

    public Sql[] generateSql(TruncateStatement truncateStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        boolean noCluster;
        boolean noTable = truncateStatement.getTableName() == null || truncateStatement.getTableName().length() == 0;
        boolean bl = noCluster = truncateStatement.getClusterName() == null || truncateStatement.getClusterName().length() == 0;
        if (noTable == noCluster) {
            throw new IllegalStateException("Either tableName or clusterName must be set");
        }
        String sql = "TRUNCATE";
        if (noCluster) {
            sql = sql + " TABLE " + database.escapeTableName(null, truncateStatement.getSchemaName(), truncateStatement.getTableName());
            if (truncateStatement.purgeMaterializedViewLog().booleanValue()) {
                sql = sql + " PURGE MATERIALIZED VIEW LOG";
            }
        } else {
            sql = sql + " CLUSTER " + database.escapeTableName(null, truncateStatement.getSchemaName(), truncateStatement.getClusterName());
        }
        if (truncateStatement.reuseStorage().booleanValue()) {
            sql = sql + " REUSE STORAGE";
        }
        return new Sql[]{new UnparsedSql(sql, new DatabaseObject[0])};
    }
}

