/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.renametrigger;

import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.ext.ora.renametrigger.RenameTriggerStatement;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class RenameTriggerGenerator
extends AbstractSqlGenerator<RenameTriggerStatement> {
    public boolean supports(RenameTriggerStatement renameTriggertStatement, Database database) {
        return database instanceof OracleDatabase;
    }

    public ValidationErrors validate(RenameTriggerStatement renameTriggerStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("triggerName", (Object)renameTriggerStatement.getTriggerName());
        return validationErrors;
    }

    public Sql[] generateSql(RenameTriggerStatement renameTriggerStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TRIGGER ");
        if (renameTriggerStatement.getSchemaName() != null) {
            sql.append(renameTriggerStatement.getSchemaName()).append(".");
        }
        if (renameTriggerStatement.getTriggerName() == null) {
            throw new IllegalStateException("Sorry but triggerName must be set");
        }
        sql.append(renameTriggerStatement.getTriggerName()).append(" ");
        if (renameTriggerStatement.getNewName() != null) {
            sql.append("RENAME TO ");
            sql.append(renameTriggerStatement.getNewName());
        }
        return new Sql[]{new UnparsedSql(sql.toString(), new DatabaseObject[0])};
    }
}

