/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.application.ui;

import com.dbeaver.application.internal.AdvancedAppMessages;
import com.dbeaver.lm.api.LMException;
import com.dbeaver.lm.api.LMLicense;
import com.dbeaver.lm.api.LMLicenseType;
import com.dbeaver.model.license.DBPLicenseService;
import com.dbeaver.model.license.app.LMAppUtils;
import com.dbeaver.model.license.embedded.LicenseServiceEmbedded;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;

public class LicensePromoHandler
extends AbstractHandler
implements IElementUpdater {
    private static final String DBEAVER_PRO_TOOLBAR = "dbeaver-pro";
    private static boolean updated;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ShellUtils.launchProgram((String)Platform.getProduct().getProperty("productPurchaseURL"));
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void updateElement(UIElement element, Map parameters) {
        LMLicense license;
        DBPLicenseService dBPLicenseService = LMAppUtils.getLicenseService();
        if (!(dBPLicenseService instanceof LicenseServiceEmbedded)) {
            return;
        }
        LicenseServiceEmbedded licenseServiceEmbedded = (LicenseServiceEmbedded)dBPLicenseService;
        try {
            void service;
            license = service.getActiveProductLicense(false);
        }
        catch (LMException lMException) {
            return;
        }
        if (license == null) {
            return;
        }
        LMLicenseType type = license.getLicenseType();
        if (type == LMLicenseType.TRIAL || type == LMLicenseType.EAP) {
            element.setText(AdvancedAppMessages.license_promo_purchase_label);
            element.setTooltip(AdvancedAppMessages.license_promo_purchase_label);
        } else {
            element.setText(AdvancedAppMessages.license_promo_extend_label);
            element.setTooltip(AdvancedAppMessages.license_promo_extend_label);
        }
        if (!updated) {
            updated = true;
            UIUtils.asyncExec(LicensePromoHandler::updateElement);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void updateElement() {
        void window;
        IWorkbenchWindow iWorkbenchWindow = UIUtils.getActiveWorkbenchWindow();
        if (!(iWorkbenchWindow instanceof WorkbenchWindow)) {
            return;
        }
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)iWorkbenchWindow;
        for (MTrimElement child : window.getTopTrim().getChildren()) {
            if (!DBEAVER_PRO_TOOLBAR.equals(child.getElementId()) || !(child instanceof MElementContainer)) continue;
            MElementContainer container = (MElementContainer)child;
            Iterator iterator = container.getChildren().iterator();
            while (iterator.hasNext()) {
                MUIElement item;
                boolean visible = (item = (MUIElement)iterator.next()).isVisible();
                item.setVisible(!visible);
                item.setVisible(visible);
            }
        }
    }
}

