/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.application;

import com.dbeaver.lm.api.LMLicense;
import com.dbeaver.ui.license.LicenseManagerUIUtils;
import java.text.SimpleDateFormat;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.IWorkbenchWindowInitializer;
import org.jkiss.dbeaver.ui.UIUtils;

public class WorkbenchInitializerLicenseCheck
implements IWorkbenchWindowInitializer {
    private static final Log log = Log.getLog(WorkbenchInitializerLicenseCheck.class);
    private static final int RC_NOT_LICENSED = 100;

    public void initializeWorkbenchWindow(@NotNull IWorkbenchWindowConfigurer configurer) {
        LMLicense license = LicenseManagerUIUtils.checkLicense((Shell)configurer.getWindow().getShell());
        if (license == null) {
            log.debug((Object)"No valid license found");
            throw this.forciblyExit(configurer, 100);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        log.debug((Object)("License: " + license.getLicenseId() + " (" + license.getLicenseType().getDisplayName() + "; " + dateFormat.format(license.getLicenseIssueTime()) + (String)(license.getLicenseEndTime() == null ? "" : " - " + dateFormat.format(license.getLicenseEndTime())) + ")"));
    }

    @NotNull
    private AssertionError forciblyExit(@NotNull IWorkbenchWindowConfigurer configurer, int status) {
        UIUtils.syncExec(() -> configurer.getWorkbenchConfigurer().emergencyClose());
        System.exit(status);
        return new AssertionError((Object)"not reached");
    }
}

