/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.application;

import com.dbeaver.model.security.AdvancedSecurityUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.net.URL;
import java.nio.ByteOrder;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import javax.crypto.Cipher;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.app.ApplicationDescriptor;
import org.jkiss.dbeaver.model.impl.app.ApplicationRegistry;
import org.osgi.framework.Version;

class ProductBuildInfo {
    private static final Log log = Log.getLog(ProductBuildInfo.class);
    private static final String PRODUCT_INFO_PATH = "product-info.properties";
    private static final String PROP_PRODUCT_VERSION = "productVersion";
    private static final String PROP_PRODUCT_RELEASE = "productRelease";
    private static final String PROP_PRODUCT_BUILD_DATE = "productBuildDate";
    private static final String PROP_PRODUCT_RELEASE_EAP = "eap";
    @Nullable
    private LocalDateTime buildDate;
    private boolean isEarlyAccessBuild;
    private static final String TRANSFORMATION = "RSA/ECB/PKCS1Padding";
    private static final String ALGORITHM = "RSA";
    private static final int EAP_KEY_LENGTH = 550;
    private static final long[] EAP_KEY = new long[]{650221696581796400L, 72354425775621674L, 4224882069996801L, 72763489260831280L, -6061090926474705920L, 6769360428801162859L, 3333511022268592353L, 4503733874245267969L, -927838094071747513L, -5785728728382524093L, 2425896998721864919L, -581047295131910493L, 1688478539903439335L, 4001821355147758372L, -6974406071655201362L, 3840347220149801090L, -3109097877278118847L, -6748522924062769345L, 3285257157325187984L, 8174276974988712017L, 7353846535764207848L, 4825739531389395967L, -306292162136933176L, -8968031015735190459L, -8451132561627331522L, -1871492277078991297L, 4830348464600860025L, -7883153898247487657L, -4388286728720258063L, -8104628840055206764L, 271884768386600428L, 3434122947463432909L, 6957731768262697387L, -6078484004226109145L, 8705874873650112742L, 4489461640018508934L, -9151390061725471368L, -8196450006897456466L, -2139349227105310224L, -1105202270830674257L, 2600815495185467489L, -1255230174801300995L, -4984476596378597042L, -7649578072302147461L, 147456109875965384L, -1246997585797048904L, 6268284672798766202L, -95842068527452801L, 6119904458154653153L, 5231428716265617246L, -3937998701386257360L, -2166408142450527463L, -5123726130589847760L, 1081141997883957139L, -2667573279619411331L, -4469440473472043559L, -7391287068822979897L, 5164510881140512730L, -3690994381053871619L, 8483739586509314015L, 292316772458819857L, -8569644879880474957L, 7193852878965282291L, -3497840245894965753L, 4418023018023111695L, 4469277621437880693L, 142072996988973812L, 3616329207647154859L, 1099528602255L};

    public ProductBuildInfo() {
        ApplicationDescriptor application = ApplicationRegistry.getInstance().getApplication();
        URL resource = application.getContributorBundle().getResource(PRODUCT_INFO_PATH);
        if (resource == null) {
            log.trace((Object)"Could not find product-info.properties");
            return;
        }
        Properties productInfo = new Properties();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream is = resource.openStream();){
                Cipher cipher = Cipher.getInstance(TRANSFORMATION);
                cipher.init(2, AdvancedSecurityUtils.getPublicKey((String)ALGORITHM, (long[])EAP_KEY, (int)550));
                productInfo.load(new ByteArrayInputStream(cipher.doFinal(is.readAllBytes())));
                Version actualVersion = application.getContributorBundle().getVersion();
                Version expectedVersion = new Version(productInfo.getProperty(PROP_PRODUCT_VERSION));
                if (!actualVersion.equals((Object)expectedVersion)) {
                    log.debug((Object)"Product version mismatch! Fishy business detected.");
                    return;
                }
                this.isEarlyAccessBuild = PROP_PRODUCT_RELEASE_EAP.equals(productInfo.getProperty(PROP_PRODUCT_RELEASE));
                String buildDateStr = productInfo.getProperty(PROP_PRODUCT_BUILD_DATE);
                this.buildDate = LocalDateTime.parse(buildDateStr, DateTimeFormatter.ISO_DATE_TIME);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.debug((Object)"Error loading product-info.properties", (Throwable)e);
        }
    }

    @Nullable
    public LocalDateTime getBuildDate() {
        return this.buildDate;
    }

    public boolean isEarlyAccessBuild() {
        return this.isEarlyAccessBuild;
    }

    @NotNull
    private static byte[] shakeDownData(@NotNull long[] input) {
        VarHandle handle = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.nativeOrder());
        byte[] buffer = new byte[input.length * 8];
        int i = 0;
        while (i < input.length) {
            handle.set(buffer, i * 8, input[i]);
            ++i;
        }
        return buffer;
    }
}

