/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.support;

import com.amazon.athena.logging.AthenaLogger;
import java.net.URI;
import java.net.URISyntaxException;

public class EndpointHelper {
    private static final AthenaLogger logger = AthenaLogger.of(EndpointHelper.class);

    public static URI constructEndpointUri(String endpoint, String endpointName) {
        try {
            String scheme;
            int schemeEndIndex = endpoint.indexOf("://");
            String string = scheme = schemeEndIndex == -1 ? null : endpoint.substring(0, schemeEndIndex);
            if (scheme == null) {
                logger.info(String.format("The provided %s endpoint \"%s\" does not start with an HTTP(S) protocol. Adding \"https://\" prefix", endpointName, endpoint), new Object[0]);
                return new URI("https://" + endpoint);
            }
            if (scheme.equalsIgnoreCase("https") || scheme.equalsIgnoreCase("http")) {
                return new URI(endpoint);
            }
            throw new IllegalArgumentException(String.format("The %s endpoint \"%s\" is not an HTTP(S) endpoint", endpointName, endpoint));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("The %s endpoint \"%s\" is not a syntactically correct URI", endpointName, endpoint), e);
        }
    }
}

