/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication;

import com.amazon.athena.jdbc.authentication.CredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.OktaCredentialsProvider;
import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import com.amazon.athena.jdbc.configuration.ConnectionParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;

public class OktaCredentialsProviderFactory
implements CredentialsProviderFactory {
    public static final ConnectionParameter<String> OKTA_APP_ID = ConnectionParameter.builder().name("OktaAppId").deprecatedAlias("App_ID").build();
    public static final ConnectionParameter<String> OKTA_APP_NAME = ConnectionParameter.builder().name("OktaAppName").deprecatedAlias("App_Name").build();
    public static final ConnectionParameter<String> OKTA_MFA_TYPE = ConnectionParameter.builder().name("OktaMfaType").deprecatedAlias("okta_mfa_type").build();
    public static final ConnectionParameter<String> OKTA_MFA_WAIT_TIME = ConnectionParameter.builder().name("OktaMfaWaitTime").deprecatedAlias("okta_mfa_wait_time").build();
    public static final ConnectionParameter<String> OKTA_PHONE_NUMBER = ConnectionParameter.builder().name("OktaPhoneNumber").deprecatedAlias("okta_phone_number").build();
    public static final int OKTA_MFA_WAIT_TIME_MIN = 20;
    public static final String TOTP_MFA_TYPE = "oktaverifywithtotp";
    public static final String PUSH_MFA_TYPE = "oktaverifywithpush";
    public static final String SMS_MFA_TYPE = "smsauthentication";
    public static final String GOOGLE_AUTHENTICATOR_MFA_TYPE = "googleauthenticator";
    private static final List<String> SUPPORTED_MFA_TYPES = Arrays.asList("oktaverifywithtotp", "oktaverifywithpush", "smsauthentication", "googleauthenticator");
    private final OktaCredentialsProvider.Builder credentialsProviderBuilder;

    public OktaCredentialsProviderFactory() {
        this.credentialsProviderBuilder = OktaCredentialsProvider.builder();
    }

    OktaCredentialsProviderFactory(OktaCredentialsProvider.Builder credentialsProviderBuilder) {
        this.credentialsProviderBuilder = credentialsProviderBuilder;
    }

    @Override
    public String name() {
        return "Okta";
    }

    @Override
    public AwsCredentialsProvider create(Map<ConnectionParameter<?>, String> parameters) {
        Integer waitTime;
        Optional<String> username = ConnectionParameters.USER_PARAMETER.findValue(parameters);
        Optional<String> password = ConnectionParameters.PASSWORD_PARAMETER.findValue(parameters);
        Optional<String> hostName = ConnectionParameters.IDP_HOST_NAME.findValue(parameters);
        Optional<String> appId = OKTA_APP_ID.findValue(parameters);
        Optional<String> appName = OKTA_APP_NAME.findValue(parameters);
        Optional<String> mfaType = OKTA_MFA_TYPE.findValue(parameters);
        Optional<String> mfaWaitTime = OKTA_MFA_WAIT_TIME.findValue(parameters);
        Optional<String> phoneNumber = OKTA_PHONE_NUMBER.findValue(parameters);
        Optional<String> preferredRole = ConnectionParameters.PREFERRED_ROLE_PARAMETER.findValue(parameters);
        Optional<Integer> roleSessionDuration = ConnectionParameters.ROLE_SESSION_DURATION_PARAMETER.findValue(parameters);
        Optional<Region> region = ConnectionParameters.REGION_PARAMETER.findValue(parameters);
        Optional<Boolean> lakeFormationEnabled = ConnectionParameters.LAKE_FORMATION_ENABLED_PARAMETER.findValue(parameters);
        ArrayList<String> errors = new ArrayList<String>();
        if (!username.isPresent()) {
            errors.add(String.format("The %s parameter must be specified when using the %s credentials provider", ConnectionParameters.USER_PARAMETER.name(), this.name()));
        }
        if (!password.isPresent()) {
            errors.add(String.format("The %s parameter must be specified when using the %s credentials provider", ConnectionParameters.PASSWORD_PARAMETER.name(), this.name()));
        }
        if (!hostName.isPresent()) {
            errors.add(String.format("The %s parameter must be specified when using the %s credentials provider", ConnectionParameters.IDP_HOST_NAME.name(), this.name()));
        }
        if (!appId.isPresent()) {
            errors.add(String.format("The %s parameter must be specified when using the %s credentials provider", OKTA_APP_ID.name(), this.name()));
        }
        if (!appName.isPresent()) {
            errors.add(String.format("The %s parameter must be specified when using the %s credentials provider", OKTA_APP_NAME.name(), this.name()));
        }
        if (mfaType.isPresent()) {
            if (!SUPPORTED_MFA_TYPES.contains(mfaType.get().toLowerCase())) {
                errors.add(String.format("The Okta MFA type \"%s\" is not a supported second factor", mfaType.get()));
            }
            if (mfaType.get().equalsIgnoreCase(SMS_MFA_TYPE) && !phoneNumber.isPresent()) {
                errors.add(String.format("A phone number must be provided when the Okta MFA type is \"SmsAuthentication\"", new Object[0]));
            }
        }
        if (mfaWaitTime.isPresent() && ((waitTime = OktaCredentialsProviderFactory.stringToInt(mfaWaitTime.get())) == null || waitTime < 20)) {
            errors.add(String.format("Invalid Okta MFA wait time: \"%s\" (expected an integer value of at least 20)", mfaWaitTime.get()));
        }
        if (!errors.isEmpty()) {
            String errorMessage = String.join((CharSequence)"; ", errors);
            throw new IllegalArgumentException(errorMessage);
        }
        return this.credentialsProviderBuilder.username(username.get()).password(password.get()).hostName(hostName.get()).appId(appId.get()).appName(appName.get()).mfaType(mfaType.orElse(null)).mfaWaitTime(mfaWaitTime.map(Integer::parseInt).orElse(null)).mfaPhoneNumber(phoneNumber.orElse(null)).preferredRole(preferredRole.orElse(null)).roleSessionDuration(roleSessionDuration.orElse(null)).region(region.get()).lakeFormationEnabled(lakeFormationEnabled.get()).connectionParameters(parameters).build();
    }

    private static Integer stringToInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public Collection<ConnectionParameter<?>> connectionParameters() {
        return Arrays.asList(ConnectionParameters.IDP_HOST_NAME, ConnectionParameters.LAKE_FORMATION_ENABLED_PARAMETER, ConnectionParameters.PASSWORD_PARAMETER, ConnectionParameters.PREFERRED_ROLE_PARAMETER, ConnectionParameters.REGION_PARAMETER, ConnectionParameters.ROLE_SESSION_DURATION_PARAMETER, ConnectionParameters.USER_PARAMETER, OKTA_APP_ID, OKTA_APP_NAME, OKTA_MFA_TYPE, OKTA_MFA_WAIT_TIME, OKTA_PHONE_NUMBER);
    }
}

