/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc;

import com.amazon.athena.jdbc.AthenaConnection;
import com.amazon.athena.jdbc.authentication.AdfsCredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.AzureAdCredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.BrowserAzureCredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.BrowserSamlCredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.CredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.CredentialsProviderRegistry;
import com.amazon.athena.jdbc.authentication.CustomCredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.DefaultCredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.InstanceProfileCredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.JwtCredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.JwtTrustedIdentityCredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.OktaCredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.PingCredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.ProfileCredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.StaticCredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.datazone.DataZoneIamCredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.datazone.DataZoneIdcCredentialsProviderFactory;
import com.amazon.athena.jdbc.cache.Cache;
import com.amazon.athena.jdbc.cache.DriverCache;
import com.amazon.athena.jdbc.configuration.ConnectionConfiguration;
import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import com.amazon.athena.jdbc.configuration.ConnectionParameters;
import com.amazon.athena.jdbc.configuration.UrlParser;
import com.amazon.athena.jdbc.support.DriverVersion;
import com.amazon.athena.logging.AthenaLogger;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Logger;

public class AthenaDriver
implements Driver {
    private static final AthenaLogger logger = AthenaLogger.of(AthenaDriver.class);
    public static final String JDBC_PROTOCOL = "jdbc:athena";
    private static final Cache DRIVER_CACHE = new DriverCache();
    private static final String DEPRECATED_JDBC_PROTOCOL = "jdbc:awsathena";
    private static final CredentialsProviderRegistry CREDENTIALS_PROVIDERS_REGISTRY = new CredentialsProviderRegistry();
    private final Collection<ConnectionParameter<?>> connectionParameters;
    private final UrlParser urlParser;
    private final BiFunction<Map<ConnectionParameter<?>, String>, CredentialsProviderRegistry, ConnectionConfiguration> connectionConfigurationFactory;
    private final Function<ConnectionConfiguration, AthenaConnection> connectionFactory;

    public AthenaDriver() {
        this(new HashSet(ConnectionParameters.connectionParameters()), ConnectionConfiguration::from, AthenaConnection::new);
    }

    AthenaDriver(Collection<ConnectionParameter<?>> connectionParameters, BiFunction<Map<ConnectionParameter<?>, String>, CredentialsProviderRegistry, ConnectionConfiguration> connectionConfigurationFactory, Function<ConnectionConfiguration, AthenaConnection> connectionFactory) {
        this(new UrlParser(JDBC_PROTOCOL, Collections.singleton(DEPRECATED_JDBC_PROTOCOL), connectionParameters), connectionParameters, connectionConfigurationFactory, connectionFactory);
    }

    AthenaDriver(UrlParser urlParser, Collection<ConnectionParameter<?>> connectionParameters, BiFunction<Map<ConnectionParameter<?>, String>, CredentialsProviderRegistry, ConnectionConfiguration> connectionConfigurationFactory, Function<ConnectionConfiguration, AthenaConnection> connectionFactory) {
        this.urlParser = urlParser;
        this.connectionParameters = connectionParameters;
        this.connectionConfigurationFactory = connectionConfigurationFactory;
        this.connectionFactory = connectionFactory;
    }

    public static void register() throws SQLException {
        if (AthenaDriver.registeredDriver() == null) {
            DriverManager.registerDriver(new AthenaDriver());
        }
    }

    public static void deregister() throws SQLException {
        DriverManager.deregisterDriver(AthenaDriver.registeredDriver());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerCredentialsProvider(CredentialsProviderFactory credentialsProviderFactory) {
        CredentialsProviderRegistry credentialsProviderRegistry = CREDENTIALS_PROVIDERS_REGISTRY;
        synchronized (credentialsProviderRegistry) {
            CREDENTIALS_PROVIDERS_REGISTRY.register(credentialsProviderFactory);
            ConnectionParameters.registerConnectionParameters(credentialsProviderFactory.connectionParameters());
        }
    }

    @Override
    public Connection connect(String url, Properties defaults) throws SQLException {
        if (url == null) {
            throw new SQLException("Connection URL cannot be null");
        }
        try {
            Optional<AthenaConnection> connection = this.urlParser.parseUrl(url, defaults).map(parameters -> this.connectionConfigurationFactory.apply((Map<ConnectionParameter<?>, String>)parameters, CREDENTIALS_PROVIDERS_REGISTRY)).map(this.connectionFactory);
            return connection.isPresent() ? connection.get().testConnection() : null;
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(String.format("Could not connect: %s", e.getMessage()), e);
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url.startsWith(DEPRECATED_JDBC_PROTOCOL) && this.isVersion2DriverRegistered()) {
            logger.warn("Another driver that accepts the Athena JDBC v2 protocol (\"jdbc:awsathena\") is already registered.In this case, the v3 driver does not accept URLs starting with this protocol", new Object[0]);
            return false;
        }
        return this.urlParser.isMatchingUrl(url);
    }

    private boolean isVersion2DriverRegistered() throws SQLException {
        Enumeration<Driver> registeredDrivers = DriverManager.getDrivers();
        while (registeredDrivers.hasMoreElements()) {
            Driver driver = registeredDrivers.nextElement();
            if (driver == this || driver.acceptsURL(JDBC_PROTOCOL) || !driver.acceptsURL(DEPRECATED_JDBC_PROTOCOL)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties defaults) {
        return this.urlParser.parseUrl(url, defaults).map(givenConnectionParameters -> (DriverPropertyInfo[])this.connectionParameters.stream().map(parameter -> {
            Optional<String> value = parameter.findValue((Map<ConnectionParameter<?>, String>)givenConnectionParameters).map(Object::toString);
            return new DriverPropertyInfo(parameter.name(), value.orElse(null));
        }).toArray(DriverPropertyInfo[]::new)).orElseGet(() -> new DriverPropertyInfo[0]);
    }

    @Override
    public int getMajorVersion() {
        return DriverVersion.instance().majorVersion();
    }

    @Override
    public int getMinorVersion() {
        return DriverVersion.instance().minorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    private static Driver registeredDriver() {
        Enumeration<Driver> e = DriverManager.getDrivers();
        while (e.hasMoreElements()) {
            Driver d = e.nextElement();
            if (d.getClass() != AthenaDriver.class) continue;
            return d;
        }
        return null;
    }

    static {
        AthenaDriver.registerCredentialsProvider(new AdfsCredentialsProviderFactory());
        AthenaDriver.registerCredentialsProvider(new AzureAdCredentialsProviderFactory());
        AthenaDriver.registerCredentialsProvider(new BrowserAzureCredentialsProviderFactory());
        AthenaDriver.registerCredentialsProvider(new BrowserSamlCredentialsProviderFactory());
        AthenaDriver.registerCredentialsProvider(new CustomCredentialsProviderFactory());
        AthenaDriver.registerCredentialsProvider(new DefaultCredentialsProviderFactory());
        AthenaDriver.registerCredentialsProvider(new InstanceProfileCredentialsProviderFactory());
        AthenaDriver.registerCredentialsProvider(new JwtCredentialsProviderFactory());
        AthenaDriver.registerCredentialsProvider(new OktaCredentialsProviderFactory());
        AthenaDriver.registerCredentialsProvider(new PingCredentialsProviderFactory());
        AthenaDriver.registerCredentialsProvider(new ProfileCredentialsProviderFactory());
        AthenaDriver.registerCredentialsProvider(new StaticCredentialsProviderFactory());
        AthenaDriver.registerCredentialsProvider(new DataZoneIdcCredentialsProviderFactory());
        AthenaDriver.registerCredentialsProvider(new DataZoneIamCredentialsProviderFactory());
        AthenaDriver.registerCredentialsProvider(new JwtTrustedIdentityCredentialsProviderFactory(DRIVER_CACHE));
        try {
            AthenaDriver.register();
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

