/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc;

import com.amazon.athena.jdbc.AthenaDriver;
import com.amazon.athena.jdbc.authentication.AdfsCredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.AzureAdCredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.JwtCredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.JwtTrustedIdentityCredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.OktaCredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.PingCredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.ProfileCredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.StaticCredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.datazone.DataZoneCredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.datazone.DataZoneIdcCredentialsProviderFactory;
import com.amazon.athena.jdbc.configuration.ConnectionParameters;
import com.amazon.athena.jdbc.support.AutoUnwrap;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class AthenaDataSource
implements DataSource,
AutoUnwrap {
    private final Driver driver;
    private String description;
    private final Properties properties;

    public AthenaDataSource() {
        this(new AthenaDriver());
    }

    AthenaDataSource(Driver driver) {
        this.driver = driver;
        this.properties = new Properties();
    }

    public void setDescription(String str) {
        this.description = str;
    }

    public String getDescription() {
        return this.description;
    }

    public void setWorkGroup(String workGroup) {
        this.properties.setProperty(ConnectionParameters.WORK_GROUP_PARAMETER.name(), workGroup);
    }

    public String getWorkGroup() {
        return this.properties.getProperty(ConnectionParameters.WORK_GROUP_PARAMETER.name());
    }

    public void setRegion(String region) {
        this.properties.setProperty(ConnectionParameters.REGION_PARAMETER.name(), region);
    }

    public String getRegion() {
        return this.properties.getProperty(ConnectionParameters.REGION_PARAMETER.name());
    }

    public void setCatalog(String catalog) {
        this.properties.setProperty(ConnectionParameters.CATALOG_PARAMETER.name(), catalog);
    }

    public String getCatalog() {
        return this.properties.getProperty(ConnectionParameters.CATALOG_PARAMETER.name());
    }

    public String getDatabase() {
        return this.properties.getProperty(ConnectionParameters.DATABASE_PARAMETER.name());
    }

    public void setOutputLocation(String outputLocation) {
        this.properties.setProperty(ConnectionParameters.OUTPUT_LOCATION_PARAMETER.name(), outputLocation);
    }

    public String getOutputLocation() {
        return this.properties.getProperty(ConnectionParameters.OUTPUT_LOCATION_PARAMETER.name());
    }

    public void setAccessKeyId(String accessKeyId) {
        this.setUser(accessKeyId);
    }

    public String getAccessKeyId() {
        return this.getUser();
    }

    public void setUser(String user) {
        this.properties.setProperty(ConnectionParameters.USER_PARAMETER.name(), user);
    }

    public String getUser() {
        return this.properties.getProperty(ConnectionParameters.USER_PARAMETER.name());
    }

    public void setSecretAccessKey(String secretAccessKey) {
        this.setPassword(secretAccessKey);
    }

    public String getSecretAccessKey() {
        return this.getPassword();
    }

    public void setPassword(String password) {
        this.properties.setProperty(ConnectionParameters.PASSWORD_PARAMETER.name(), password);
    }

    public String getPassword() {
        return this.properties.getProperty(ConnectionParameters.PASSWORD_PARAMETER.name());
    }

    public void setSessionToken(String sessionToken) {
        this.properties.setProperty(StaticCredentialsProviderFactory.SESSION_TOKEN_PARAMETER.name(), sessionToken);
    }

    public String getSessionToken() {
        return this.properties.getProperty(StaticCredentialsProviderFactory.SESSION_TOKEN_PARAMETER.name());
    }

    public void setEncryptionOption(String encryptionOption) {
        this.properties.setProperty(ConnectionParameters.ENCRYPTION_OPTION_PARAMETER.name(), encryptionOption);
    }

    public String getEncryptionOption() {
        return this.properties.getProperty(ConnectionParameters.ENCRYPTION_OPTION_PARAMETER.name());
    }

    public void setExpectedBucketOwner(String expectedBucketOwner) {
        this.properties.setProperty(ConnectionParameters.EXPECTED_BUCKET_OWNER_PARAMETER.name(), expectedBucketOwner);
    }

    public String getExpectedBucketOwner() {
        return this.properties.getProperty(ConnectionParameters.EXPECTED_BUCKET_OWNER_PARAMETER.name());
    }

    public void setAclOption(String aclOption) {
        this.properties.setProperty(ConnectionParameters.ACL_OPTION_PARAMETER.name(), aclOption);
    }

    public String getAclOption() {
        return this.properties.getProperty(ConnectionParameters.ACL_OPTION_PARAMETER.name());
    }

    public void setKmsKey(String kmsKey) {
        this.properties.setProperty(ConnectionParameters.KMS_KEY_PARAMETER.name(), kmsKey);
    }

    public String getKmsKey() {
        return this.properties.getProperty(ConnectionParameters.KMS_KEY_PARAMETER.name());
    }

    public void setFetchSize(String size) {
        this.properties.setProperty(ConnectionParameters.FETCH_SIZE_PARAMETER.name(), size);
    }

    public String getFetchSize() {
        return this.properties.getProperty(ConnectionParameters.FETCH_SIZE_PARAMETER.name());
    }

    public void setDatabase(String database) {
        this.properties.setProperty(ConnectionParameters.DATABASE_PARAMETER.name(), database);
    }

    public void setMinQueryExecutionPollingIntervalMillis(String millis) {
        this.properties.setProperty(ConnectionParameters.MIN_QUERY_EXECUTION_POLLING_INTERVAL_MILLIS_PARAMETER.name(), millis);
    }

    public String getMinQueryExecutionPollingIntervalMillis() {
        return this.properties.getProperty(ConnectionParameters.MIN_QUERY_EXECUTION_POLLING_INTERVAL_MILLIS_PARAMETER.name());
    }

    public void setMaxQueryExecutionPollingIntervalMillis(String millis) {
        this.properties.setProperty(ConnectionParameters.MAX_QUERY_EXECUTION_POLLING_INTERVAL_MILLIS_PARAMETER.name(), millis);
    }

    public String getMaxQueryExecutionPollingIntervalMillis() {
        return this.properties.getProperty(ConnectionParameters.MAX_QUERY_EXECUTION_POLLING_INTERVAL_MILLIS_PARAMETER.name());
    }

    public void setQueryExecutionPollingIntervalMultiplier(String multiplier) {
        this.properties.setProperty(ConnectionParameters.QUERY_EXECUTION_POLLING_INTERVAL_MULTIPLIER_PARAMETER.name(), multiplier);
    }

    public String getQueryExecutionPollingIntervalMultiplier() {
        return this.properties.getProperty(ConnectionParameters.QUERY_EXECUTION_POLLING_INTERVAL_MULTIPLIER_PARAMETER.name());
    }

    public void setConnectionTest(String connectionTest) {
        this.properties.setProperty(ConnectionParameters.CONNECTION_TEST_PARAMETER.name(), connectionTest);
    }

    public String getConnectionTest() {
        return this.properties.getProperty(ConnectionParameters.CONNECTION_TEST_PARAMETER.name());
    }

    public void setAthenaEndpoint(String endpoint) {
        this.properties.setProperty(ConnectionParameters.ATHENA_ENDPOINT_PARAMETER.name(), endpoint);
    }

    public String getAthenaEndpoint() {
        return this.properties.getProperty(ConnectionParameters.ATHENA_ENDPOINT_PARAMETER.name());
    }

    public void setAthenaStreamingEndpoint(String endpoint) {
        this.properties.setProperty(ConnectionParameters.ATHENA_STREAMING_ENDPOINT_PARAMETER.name(), endpoint);
    }

    public String getAthenaStreamingEndpoint() {
        return this.properties.getProperty(ConnectionParameters.ATHENA_STREAMING_ENDPOINT_PARAMETER.name());
    }

    public void setS3Endpoint(String endpoint) {
        this.properties.setProperty(ConnectionParameters.S3_ENDPOINT_PARAMETER.name(), endpoint);
    }

    public String getS3Endpoint() {
        return this.properties.getProperty(ConnectionParameters.S3_ENDPOINT_PARAMETER.name());
    }

    public void setNumRetries(String retries) {
        this.properties.setProperty(ConnectionParameters.NUM_RETRIES_PARAMETER.name(), retries);
    }

    public void setSsoOidcEndpoint(String endpoint) {
        this.properties.setProperty(ConnectionParameters.SSO_OIDC_ENDPOINT_PARAMETER.name(), endpoint);
    }

    public String getSsoOidcEndpoint() {
        return this.properties.getProperty(ConnectionParameters.SSO_OIDC_ENDPOINT_PARAMETER.name());
    }

    public void setSsoAdminEndpoint(String endpoint) {
        this.properties.setProperty(ConnectionParameters.SSO_ADMIN_ENDPOINT_PARAMETER.name(), endpoint);
    }

    public String getSsoAdminEndpoint() {
        return this.properties.getProperty(ConnectionParameters.SSO_ADMIN_ENDPOINT_PARAMETER.name());
    }

    public String getNumRetries() {
        return this.properties.getProperty(ConnectionParameters.NUM_RETRIES_PARAMETER.name());
    }

    public void setNetworkTimeoutMillis(String networkTimeoutMillis) {
        this.properties.setProperty(ConnectionParameters.NETWORK_TIMEOUT_MILLIS.name(), networkTimeoutMillis);
    }

    public String getNetworkTimeoutMillis() {
        return this.properties.getProperty(ConnectionParameters.NETWORK_TIMEOUT_MILLIS.name());
    }

    public void setEnableResultReuseByAge(String enableResultReuseByAge) {
        this.properties.setProperty(ConnectionParameters.ENABLE_RESULT_REUSE_BY_AGE_PARAMETER.name(), enableResultReuseByAge);
    }

    public String getEnableResultReuseByAge() {
        return this.properties.getProperty(ConnectionParameters.ENABLE_RESULT_REUSE_BY_AGE_PARAMETER.name());
    }

    public void setMaxResultReuseAgeInMinutes(String minutes) {
        this.properties.setProperty(ConnectionParameters.MAX_RESULT_REUSE_AGE_IN_MINUTES_PARAMETER.name(), minutes);
    }

    public String getMaxResultReuseAgeInMinutes() {
        return this.properties.getProperty(ConnectionParameters.MAX_RESULT_REUSE_AGE_IN_MINUTES_PARAMETER.name());
    }

    public void setLogLevel(String level) {
        this.properties.setProperty(ConnectionParameters.LOG_LEVEL_PARAMETER.name(), level);
    }

    public String getLogLevel() {
        return this.properties.getProperty(ConnectionParameters.LOG_LEVEL_PARAMETER.name());
    }

    public void setLogPath(String path) {
        this.properties.setProperty(ConnectionParameters.LOG_PATH_PARAMETER.name(), path);
    }

    public String getLogPath() {
        return this.properties.getProperty(ConnectionParameters.LOG_PATH_PARAMETER.name());
    }

    public void setCredentialsProvider(String provider) {
        this.properties.setProperty(ConnectionParameters.CREDENTIALS_PROVIDER_PARAMETER.name(), provider);
    }

    public String getCredentialsProvider() {
        return this.properties.getProperty(ConnectionParameters.CREDENTIALS_PROVIDER_PARAMETER.name());
    }

    public void setCredentialsProviderArguments(String arguments) {
        this.properties.setProperty(ConnectionParameters.CREDENTIALS_PROVIDER_ARGUMENTS_PARAMETER.name(), arguments);
    }

    public String getCredentialsProviderArguments() {
        return this.properties.getProperty(ConnectionParameters.CREDENTIALS_PROVIDER_ARGUMENTS_PARAMETER.name());
    }

    public void setProfileName(String profileName) {
        this.properties.setProperty(ProfileCredentialsProviderFactory.PROFILE_NAME_PARAMETER.name(), profileName);
    }

    public String getProfileName() {
        return this.properties.getProperty(ProfileCredentialsProviderFactory.PROFILE_NAME_PARAMETER.name());
    }

    public void setAzureAdTenantId(String tenantId) {
        this.properties.setProperty(AzureAdCredentialsProviderFactory.AZURE_AD_TENANT_ID.name(), tenantId);
    }

    public String getAzureAdTenantId() {
        return this.properties.getProperty(AzureAdCredentialsProviderFactory.AZURE_AD_TENANT_ID.name());
    }

    public String getIdpResponseTimeout() {
        return this.properties.getProperty(ConnectionParameters.IDP_RESPONSE_TIMEOUT.name());
    }

    public void setIdpResponseTimeout(String responseTimeout) {
        this.properties.setProperty(ConnectionParameters.IDP_RESPONSE_TIMEOUT.name(), responseTimeout);
    }

    public String getSsoLoginUrl() {
        return this.properties.getProperty(ConnectionParameters.SSO_LOGIN_URL.name());
    }

    public void setSsoLoginUrl(String loginUrl) {
        this.properties.setProperty(ConnectionParameters.SSO_LOGIN_URL.name(), loginUrl);
    }

    public String getListenPort() {
        return this.properties.getProperty(ConnectionParameters.LISTEN_PORT.name());
    }

    public void setListenPort(String listenPort) {
        this.properties.setProperty(ConnectionParameters.LISTEN_PORT.name(), listenPort);
    }

    public void setIdpHostName(String hostName) {
        this.properties.setProperty(ConnectionParameters.IDP_HOST_NAME.name(), hostName);
    }

    public String getIdpHostName() {
        return this.properties.getProperty(ConnectionParameters.IDP_HOST_NAME.name());
    }

    public void setIdpPortNumber(String portNumber) {
        this.properties.setProperty(ConnectionParameters.IDP_PORT_NUMBER.name(), portNumber);
    }

    public String getIdpPortNumber() {
        return this.properties.getProperty(ConnectionParameters.IDP_PORT_NUMBER.name());
    }

    public void setAzureAdClientId(String clientId) {
        this.properties.setProperty(AzureAdCredentialsProviderFactory.AZURE_AD_CLIENT_ID.name(), clientId);
    }

    public String getAzureAdClientId() {
        return this.properties.getProperty(AzureAdCredentialsProviderFactory.AZURE_AD_CLIENT_ID.name());
    }

    public void setAzureAdClientSecret(String clientSecret) {
        this.properties.setProperty(AzureAdCredentialsProviderFactory.AZURE_AD_CLIENT_SECRET.name(), clientSecret);
    }

    public String getAzureAdClientSecret() {
        return this.properties.getProperty(AzureAdCredentialsProviderFactory.AZURE_AD_CLIENT_SECRET.name());
    }

    public void setOktaAppId(String appId) {
        this.properties.setProperty(OktaCredentialsProviderFactory.OKTA_APP_ID.name(), appId);
    }

    public String getOktaAppId() {
        return this.properties.getProperty(OktaCredentialsProviderFactory.OKTA_APP_ID.name());
    }

    public void setOktaAppName(String appName) {
        this.properties.setProperty(OktaCredentialsProviderFactory.OKTA_APP_NAME.name(), appName);
    }

    public String getOktaAppName() {
        return this.properties.getProperty(OktaCredentialsProviderFactory.OKTA_APP_NAME.name());
    }

    public void setOktaMfaType(String oktaMfaType) {
        this.properties.setProperty(OktaCredentialsProviderFactory.OKTA_MFA_TYPE.name(), oktaMfaType);
    }

    public String getOktaMfaType() {
        return this.properties.getProperty(OktaCredentialsProviderFactory.OKTA_MFA_TYPE.name());
    }

    public void setOktaMfaWaitTime(String oktaMfaWaitTime) {
        this.properties.setProperty(OktaCredentialsProviderFactory.OKTA_MFA_WAIT_TIME.name(), oktaMfaWaitTime);
    }

    public String getOktaMfaWaitTime() {
        return this.properties.getProperty(OktaCredentialsProviderFactory.OKTA_MFA_WAIT_TIME.name());
    }

    public void setOktaPhoneNumber(String oktaPhoneNumber) {
        this.properties.setProperty(OktaCredentialsProviderFactory.OKTA_PHONE_NUMBER.name(), oktaPhoneNumber);
    }

    public String getOktaPhoneNumber() {
        return this.properties.getProperty(OktaCredentialsProviderFactory.OKTA_PHONE_NUMBER.name());
    }

    public void setPingPartnerSpId(String partnerSpId) {
        this.properties.setProperty(PingCredentialsProviderFactory.PING_PARTNER_SPID.name(), partnerSpId);
    }

    public String getPingPartnerSpId() {
        return this.properties.getProperty(PingCredentialsProviderFactory.PING_PARTNER_SPID.name());
    }

    public void setAdfsRelyingParty(String relyingParty) {
        this.properties.setProperty(AdfsCredentialsProviderFactory.ADFS_RELYING_PARTY.name(), relyingParty);
    }

    public String getAdfsRelyingParty() {
        return this.properties.getProperty(AdfsCredentialsProviderFactory.ADFS_RELYING_PARTY.name());
    }

    public void setAdfsWiaEnabled(String wiaEnabled) {
        this.properties.setProperty(AdfsCredentialsProviderFactory.ADFS_WIA_ENABLED.name(), wiaEnabled);
    }

    public String getAdfsWiaEnabled() {
        return this.properties.getProperty(AdfsCredentialsProviderFactory.ADFS_WIA_ENABLED.name());
    }

    public String getDataZoneDomainId() {
        return this.properties.getProperty(DataZoneIdcCredentialsProviderFactory.DATAZONE_DOMAIN_ID_PARAMETER.name());
    }

    public String getDataZoneEnvironmentId() {
        return this.properties.getProperty(DataZoneIdcCredentialsProviderFactory.DATAZONE_ENVIRONMENT_ID_PARAMETER.name());
    }

    public String getDataZoneDomainRegion() {
        return this.properties.getProperty(DataZoneIdcCredentialsProviderFactory.DATAZONE_DOMAIN_REGION_PARAMETER.name());
    }

    public String getDataZoneEndpointOverride() {
        return this.properties.getProperty(DataZoneIdcCredentialsProviderFactory.DATAZONE_ENDPOINT_OVERRIDE_PARAMETER.name());
    }

    public String getIdentityCenterIssuerUrl() {
        return this.properties.getProperty(DataZoneIdcCredentialsProviderFactory.IDENTITY_CENTER_ISSUER_URL_PARAMETER.name());
    }

    public String getEnableTokenCaching() {
        return this.properties.getProperty(DataZoneIdcCredentialsProviderFactory.ENABLE_TOKEN_CACHING.name());
    }

    public void setRoleSessionDuration(String roleSessionDuration) {
        this.properties.setProperty(ConnectionParameters.ROLE_SESSION_DURATION_PARAMETER.name(), roleSessionDuration);
    }

    public String getRoleSessionDuration() {
        return this.properties.getProperty(ConnectionParameters.ROLE_SESSION_DURATION_PARAMETER.name());
    }

    public void setPreferredRole(String preferredRole) {
        this.properties.setProperty(ConnectionParameters.PREFERRED_ROLE_PARAMETER.name(), preferredRole);
    }

    public String getPreferredRole() {
        return this.properties.getProperty(ConnectionParameters.PREFERRED_ROLE_PARAMETER.name());
    }

    public void setJwtWebIdentityToken(String jwtWebIdentityToken) {
        this.properties.setProperty(ConnectionParameters.JWT_WEB_IDENTITY_TOKEN_PARAMETER.name(), jwtWebIdentityToken);
    }

    public String getJwtWebIdentityToken() {
        return this.properties.getProperty(ConnectionParameters.JWT_WEB_IDENTITY_TOKEN_PARAMETER.name());
    }

    public void setJwtRoleArn(String jwtRoleArn) {
        this.properties.setProperty(JwtCredentialsProviderFactory.JWT_ROLE_ARN_PARAMETER.name(), jwtRoleArn);
    }

    public String getJwtRoleArn() {
        return this.properties.getProperty(JwtCredentialsProviderFactory.JWT_ROLE_ARN_PARAMETER.name());
    }

    public void setJwtRoleSessionName(String jwtRoleSessionName) {
        this.properties.setProperty(ConnectionParameters.JWT_ROLE_SESSION_NAME_PARAMETER.name(), jwtRoleSessionName);
    }

    public String getJwtRoleSessionName() {
        return this.properties.getProperty(ConnectionParameters.JWT_ROLE_SESSION_NAME_PARAMETER.name());
    }

    public void setLakeFormationEnabled(String lakeFormationEnabled) {
        this.properties.setProperty(ConnectionParameters.LAKE_FORMATION_ENABLED_PARAMETER.name(), lakeFormationEnabled);
    }

    public String getLakeFormationEnabled() {
        return this.properties.getProperty(ConnectionParameters.LAKE_FORMATION_ENABLED_PARAMETER.name());
    }

    public void setStsEndpoint(String endpoint) {
        this.properties.setProperty(ConnectionParameters.STS_ENDPOINT_PARAMETER.name(), endpoint);
    }

    public String getStsEndpoint() {
        return this.properties.getProperty(ConnectionParameters.STS_ENDPOINT_PARAMETER.name());
    }

    public void setLakeFormationEndpoint(String endpoint) {
        this.properties.setProperty(ConnectionParameters.LAKE_FORMATION_ENDPOINT_PARAMETER.name(), endpoint);
    }

    public String getLakeFormationEndpoint() {
        return this.properties.getProperty(ConnectionParameters.LAKE_FORMATION_ENDPOINT_PARAMETER.name());
    }

    public void setProxyHost(String host) {
        this.properties.setProperty(ConnectionParameters.PROXY_HOST_PARAMETER.name(), host);
    }

    public String getProxyHost() {
        return this.properties.getProperty(ConnectionParameters.PROXY_HOST_PARAMETER.name());
    }

    public void setProxyPort(String port) {
        this.properties.setProperty(ConnectionParameters.PROXY_PORT_PARAMETER.name(), port);
    }

    public String getProxyPort() {
        return this.properties.getProperty(ConnectionParameters.PROXY_PORT_PARAMETER.name());
    }

    public void setProxyUsername(String username) {
        this.properties.setProperty(ConnectionParameters.PROXY_USERNAME_PARAMETER.name(), username);
    }

    public String getProxyUsername() {
        return this.properties.getProperty(ConnectionParameters.PROXY_USERNAME_PARAMETER.name());
    }

    public void setProxyPassword(String password) {
        this.properties.setProperty(ConnectionParameters.PROXY_PASSWORD_PARAMETER.name(), password);
    }

    public String getProxyPassword() {
        return this.properties.getProperty(ConnectionParameters.PROXY_PASSWORD_PARAMETER.name());
    }

    public void setProxyExemptHosts(String hosts) {
        this.properties.setProperty(ConnectionParameters.PROXY_EXEMPT_HOSTS_PARAMETER.name(), hosts);
    }

    public String getProxyExemptHosts() {
        return this.properties.getProperty(ConnectionParameters.PROXY_EXEMPT_HOSTS_PARAMETER.name());
    }

    public void setProxyEnabledForIdP(String hosts) {
        this.properties.setProperty(ConnectionParameters.PROXY_ENABLED_FOR_IDP_PARAMETER.name(), hosts);
    }

    public String getProxyEnabledForIdP() {
        return this.properties.getProperty(ConnectionParameters.PROXY_ENABLED_FOR_IDP_PARAMETER.name());
    }

    public void setApplicationName(String applicationName) {
        this.properties.setProperty(ConnectionParameters.APPLICATION_NAME_PARAMETER.name(), applicationName);
    }

    public String getApplicationName() {
        return this.properties.getProperty(ConnectionParameters.APPLICATION_NAME_PARAMETER.name());
    }

    public void setResultFetcher(String resultFetcher) {
        this.properties.setProperty(ConnectionParameters.RESULT_FETCHER.name(), resultFetcher);
    }

    public String getResultFetcher() {
        return this.properties.getProperty(ConnectionParameters.RESULT_FETCHER.name());
    }

    public void setLegacyModes(String legacyModes) {
        this.properties.setProperty(ConnectionParameters.LEGACY_MODES_PARAMETER.name(), legacyModes);
    }

    public void setDataZoneDomainId(String dataZoneDomainId) {
        this.properties.setProperty(DataZoneCredentialsProviderFactory.DATAZONE_DOMAIN_ID_PARAMETER.name(), dataZoneDomainId);
    }

    public void setDataZoneEnvironmentId(String dataZoneEnvironmentId) {
        this.properties.setProperty(DataZoneCredentialsProviderFactory.DATAZONE_ENVIRONMENT_ID_PARAMETER.name(), dataZoneEnvironmentId);
    }

    public void setDataZoneDomainRegion(String dataZoneDomainRegion) {
        this.properties.setProperty(DataZoneCredentialsProviderFactory.DATAZONE_DOMAIN_REGION_PARAMETER.name(), dataZoneDomainRegion);
    }

    public void setDataZoneEndpointOverride(String dataZoneEndpointOverride) {
        this.properties.setProperty(DataZoneCredentialsProviderFactory.DATAZONE_ENDPOINT_OVERRIDE_PARAMETER.name(), dataZoneEndpointOverride);
    }

    public void setIdentityCenterIssuerUrl(String identityCenterIssuerUrl) {
        this.properties.setProperty(DataZoneIdcCredentialsProviderFactory.IDENTITY_CENTER_ISSUER_URL_PARAMETER.name(), identityCenterIssuerUrl);
    }

    public void setEnableTokenCaching(String enableTokenCaching) {
        this.properties.setProperty(DataZoneIdcCredentialsProviderFactory.ENABLE_TOKEN_CACHING.name(), enableTokenCaching);
    }

    public String getLegacyModes() {
        return this.properties.getProperty(ConnectionParameters.LEGACY_MODES_PARAMETER.name());
    }

    public void setApplicationRoleArn(String applicationRoleArn) {
        this.properties.setProperty(JwtTrustedIdentityCredentialsProviderFactory.APPLICATION_ROLE_ARN_PARAMETER.name(), applicationRoleArn);
    }

    public String getApplicationRoleArn() {
        return this.properties.getProperty(JwtTrustedIdentityCredentialsProviderFactory.APPLICATION_ROLE_ARN_PARAMETER.name());
    }

    public void setWorkgroupArn(String workGroupArn) {
        this.properties.setProperty(JwtTrustedIdentityCredentialsProviderFactory.WORKGROUP_ARN_PARAMETER.name(), workGroupArn);
    }

    public String getWorkgroupArn() {
        return this.properties.getProperty(JwtTrustedIdentityCredentialsProviderFactory.WORKGROUP_ARN_PARAMETER.name());
    }

    public void setCustomerIdcApplicationArn(String customerIdcApplicationArn) {
        this.properties.setProperty(ConnectionParameters.CUSTOMER_IDC_APPLICATION_ARN.name(), customerIdcApplicationArn);
    }

    public String getCustomerIdcApplicationArn() {
        return this.properties.getProperty(ConnectionParameters.CUSTOMER_IDC_APPLICATION_ARN.name());
    }

    public void setAccessRoleArn(String accessRoleArn) {
        this.properties.setProperty(ConnectionParameters.ACCESS_ROLE_ARN.name(), accessRoleArn);
    }

    public String getAccessRoleArn() {
        return this.properties.getProperty(ConnectionParameters.ACCESS_ROLE_ARN.name());
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.driver.connect("jdbc:athena", this.properties);
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        Properties propertiesCopy = new Properties();
        for (Object propertyName : this.properties.keySet()) {
            if (propertyName == StaticCredentialsProviderFactory.SESSION_TOKEN_PARAMETER.name()) continue;
            propertiesCopy.put(propertyName, this.properties.get(propertyName));
        }
        propertiesCopy.setProperty(ConnectionParameters.USER_PARAMETER.name(), user);
        propertiesCopy.setProperty(ConnectionParameters.PASSWORD_PARAMETER.name(), password);
        return this.driver.connect("jdbc:athena", propertiesCopy);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        if (out != null) {
            throw new SQLFeatureNotSupportedException("Logging through a log writer is not supported");
        }
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        if (seconds != 0) {
            throw new SQLFeatureNotSupportedException("Configuring the login timeout is not supported");
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Logging through java.util.logging is not supported");
    }
}

