/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.client.results;

import com.amazon.athena.client.error.QueryExecutionException;
import com.amazon.athena.client.results.AsyncQueryResults;
import com.amazon.athena.client.results.AsyncQueryResultsFactory;
import com.amazon.athena.client.results.ResultParserFactory;
import com.amazon.athena.client.results.S3StreamingQueryResults;
import com.amazon.athena.client.results.parsing.metadata.MetadataFetcher;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.model.EncryptionOption;
import software.amazon.awssdk.services.athena.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.athena.model.QueryExecution;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.utils.CompletableFutureUtils;

public class S3StreamingQueryResultsFactory
implements AsyncQueryResultsFactory {
    private final AthenaAsyncClient athenaClient;
    private final S3AsyncClient s3Client;
    private final int fetchSize;
    private final ResultParserFactory resultParserFactory;
    private final boolean alwaysValidateMetadataAccess;
    private final Executor executor;

    public S3StreamingQueryResultsFactory(AthenaAsyncClient athenaClient, S3AsyncClient s3Client, Executor executor, ResultParserFactory resultParserFactory, boolean alwaysValidateMetadataAccess) {
        this.athenaClient = athenaClient;
        this.s3Client = s3Client;
        this.executor = executor;
        this.fetchSize = resultParserFactory.getFetchSize();
        this.resultParserFactory = resultParserFactory;
        this.alwaysValidateMetadataAccess = alwaysValidateMetadataAccess;
    }

    @Override
    public CompletionStage<AsyncQueryResults> create(QueryExecution queryMetadata) {
        if (queryMetadata.resultConfiguration() == null || queryMetadata.resultConfiguration().outputLocation() == null) {
            return CompletableFutureUtils.failedFuture((Throwable)new QueryExecutionException(queryMetadata, "Cannot stream results from S3 because no output location was found - if you are using a workgroup with managed storage configured, use the GetQueryResultsStream or GetQueryResults fetcher"));
        }
        if (queryMetadata.resultConfiguration().encryptionConfiguration() != null && queryMetadata.resultConfiguration().encryptionConfiguration().encryptionOption().equals((Object)EncryptionOption.CSE_KMS)) {
            return CompletableFutureUtils.failedFuture((Throwable)new QueryExecutionException(queryMetadata, "Cannot stream results from S3 because the CSE KMS encryption option was used - use the GetQueryResultsStream or GetQueryResults fetcher"));
        }
        MetadataFetcher metadataFetcher = this.resultParserFactory.getS3MetadataFetcher(this.athenaClient, this.s3Client, queryMetadata, this.alwaysValidateMetadataAccess);
        CompletableFuture<GetQueryResultsResponse> pendingResponseMetadata = metadataFetcher.fetchMetadata();
        return pendingResponseMetadata.thenApply(responseMetadata -> new S3StreamingQueryResults(this.s3Client, this.executor, queryMetadata, responseMetadata.resultSet().resultSetMetadata(), responseMetadata.updateCount(), this.fetchSize, this.resultParserFactory));
    }
}

