/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.upd.protocol;

import com.dbeaver.jdbc.upd.protocol.UPDStruct;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class UPDStructAdapter
implements JsonSerializer<UPDStruct>,
JsonDeserializer<UPDStruct> {
    public JsonElement serialize(UPDStruct src, Type typeOfSrc, JsonSerializationContext context) {
        try {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("sqlTypeName", src.getSQLTypeName());
            jsonObject.add("attributes", context.serialize((Object)src.getAttributes()));
            return jsonObject;
        }
        catch (Exception e) {
            throw new JsonParseException((Throwable)e);
        }
    }

    public UPDStruct deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            throw new JsonParseException("Expected a JSON object");
        }
        JsonObject jsonObject = json.getAsJsonObject();
        String sqlTypeName = jsonObject.has("sqlTypeName") ? jsonObject.get("sqlTypeName").getAsString() : null;
        JsonArray attributesArray = jsonObject.getAsJsonArray("attributes");
        Object[] attributes = (Object[])context.deserialize((JsonElement)attributesArray, Object[].class);
        return new UPDStruct(sqlTypeName, attributes);
    }
}

