/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.upd.protocol;

import com.dbeaver.jdbc.upd.protocol.UPDUtils;
import java.sql.SQLException;

public class UPDStatementParameter {
    private final String name;
    private final int index;
    private final int type;
    private final String value;

    public UPDStatementParameter(String name, int index, int type, String value) {
        this.name = name;
        this.index = index;
        this.type = type;
        this.value = value;
    }

    public static UPDStatementParameter of(Object key, Object param) throws SQLException {
        int type = UPDUtils.inferType(param);
        String value = UPDUtils.toStringPresentation(param);
        if (key instanceof Number) {
            return new UPDStatementParameter(null, ((Number)key).intValue(), type, value);
        }
        return new UPDStatementParameter(key.toString(), -1, type, value);
    }

    public String name() {
        return this.name;
    }

    public int index() {
        return this.index;
    }

    public int type() {
        return this.type;
    }

    public String value() {
        return this.value;
    }
}

