/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.upd.protocol;

import com.dbeaver.jdbc.upd.protocol.UPDColumnFlag;
import com.dbeaver.jdbc.upd.protocol.UPDException;
import java.util.EnumSet;

public class UPDResultSetMetaData {
    private final ColumnInfo[] columns;

    public UPDResultSetMetaData(ColumnInfo[] columns) {
        this.columns = columns;
    }

    public ColumnInfo[] getColumns() {
        return this.columns;
    }

    public ColumnInfo getColumn(int index) throws UPDException {
        if (index <= 0 || index > this.columns.length) {
            throw new UPDException("Column index out of range " + index + " > " + this.columns.length);
        }
        return this.columns[index - 1];
    }

    public static class ColumnInfo {
        private String catalog;
        private String schema;
        private String table;
        private String name;
        private String label;
        private int type;
        private String typeName;
        private int displaySize;
        private String className;
        private Integer precision;
        private Integer scale;
        private EnumSet<UPDColumnFlag> flags;

        public ColumnInfo(String catalog, String schema, String table, String name, String label, int type, String typeName, int displaySize, String className, Integer precision, Integer scale, EnumSet<UPDColumnFlag> flags) {
            this.catalog = catalog;
            this.schema = schema;
            this.table = table;
            this.name = name;
            this.label = label;
            this.type = type;
            this.typeName = typeName;
            this.displaySize = displaySize;
            this.className = className;
            this.precision = precision;
            this.scale = scale;
            this.flags = flags;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public String getSchema() {
            return this.schema;
        }

        public String getTable() {
            return this.table;
        }

        public String getName() {
            return this.name;
        }

        public String getLabel() {
            return this.label;
        }

        public int getType() {
            return this.type;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public int getDisplaySize() {
            return this.displaySize;
        }

        public String getClassName() {
            return this.className;
        }

        public Integer getPrecision() {
            return this.precision;
        }

        public Integer getScale() {
            return this.scale;
        }

        public boolean hasFlag(UPDColumnFlag state) {
            return this.flags.contains((Object)state);
        }

        public String toString() {
            return this.name + " " + this.typeName;
        }
    }
}

