/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mssql.model;

import com.dbeaver.db.mssql.SQLServerMessagesExt;
import com.dbeaver.db.mssql.model.SQLServerJob;
import java.sql.ResultSet;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObject;
import org.jkiss.dbeaver.model.DBPEnumWithValue;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPUniqueObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectWithScript;

public class SQLServerJobStep
implements SQLServerObject,
DBPUniqueObject,
DBSObjectWithScript {
    private final SQLServerJob job;
    private final String id;
    private final String name;
    private final int position;
    private final String type;
    private final String command;
    private final ActionType onSuccessAction;
    private final ActionType onFailureAction;
    private final int onSuccessStepId;
    private final int onFailureStepId;

    public SQLServerJobStep(@NotNull SQLServerJob job, @NotNull ResultSet dbResult) {
        this.job = job;
        this.id = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"step_uid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"step_name");
        this.position = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"step_id");
        this.type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"subsystem");
        this.command = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"command");
        this.onSuccessAction = (ActionType)JDBCUtils.safeGetEnum((ResultSet)dbResult, (String)"on_success_action", ActionType.class);
        this.onFailureAction = (ActionType)JDBCUtils.safeGetEnum((ResultSet)dbResult, (String)"on_fail_action", ActionType.class);
        this.onSuccessStepId = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"on_success_step_id");
        this.onFailureStepId = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"on_fail_step_id");
    }

    @NotNull
    public String getUniqueName() {
        return this.id;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public int getPosition() {
        return this.position;
    }

    @Property(viewable=true, order=3)
    @NotNull
    public String getType() {
        return this.type;
    }

    @Property(viewable=true, order=4)
    @Nullable
    public Object getOnSuccessAction(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.onSuccessAction == ActionType.GOTO_STEP) {
            return this.job.getStep(monitor, this.onSuccessStepId);
        }
        return this.onSuccessAction;
    }

    @Property(viewable=true, order=5)
    @Nullable
    public Object getOnFailureAction(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.onFailureAction == ActionType.GOTO_STEP) {
            return this.job.getStep(monitor, this.onFailureStepId);
        }
        return this.onFailureAction;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public long getObjectId() {
        return this.id.hashCode();
    }

    public boolean isPersisted() {
        return true;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.job;
    }

    @NotNull
    public SQLServerDataSource getDataSource() {
        return this.job.getDataSource();
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) {
        return this.command;
    }

    public void setObjectDefinitionText(String source) {
    }

    @Nullable
    public SQLServerDatabase getDatabase() {
        return null;
    }

    public static enum ActionType implements DBPNamedObject,
    DBPEnumWithValue
    {
        QUIT_WITH_SUCCESS(1, SQLServerMessagesExt.agent_job_step_action_quit_with_success),
        QUIT_WITH_FAILURE(2, SQLServerMessagesExt.agent_job_step_action_quit_with_failure),
        GOTO_NEXT_STEP(3, SQLServerMessagesExt.agent_job_step_action_goto_next_step),
        GOTO_STEP(4, SQLServerMessagesExt.agent_job_step_action_goto_step);

        private final int value;
        private final String label;

        private ActionType(int value, String label) {
            this.value = value;
            this.label = label;
        }

        public int getValue() {
            return this.value;
        }

        @NotNull
        public String getName() {
            return this.label;
        }
    }
}

