/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mssql.model;

import com.dbeaver.db.mssql.model.SQLServerJob;
import java.sql.ResultSet;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Objects;
import java.util.StringJoiner;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObject;
import org.jkiss.dbeaver.model.DBPEnumWithValue;
import org.jkiss.dbeaver.model.DBPStatefulObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.utils.CommonUtils;

public class SQLServerJobSchedule
implements SQLServerObject,
DBPStatefulObject {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT);
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM);
    private final SQLServerJob job;
    private final int id;
    private final String name;
    private final String description;
    private final boolean enabled;
    private final FrequencyType frequencyType;
    private final FrequencySubdayType frequencySubdayType;
    private final int frequencyInterval;
    private final int frequencyDayInterval;
    private final int frequencyRelativeInterval;
    private final int frequencyRecurrenceFactor;
    private final LocalDateTime startDateTime;
    private final LocalDateTime endDateTime;

    public SQLServerJobSchedule(@NotNull SQLServerJob job, @NotNull ResultSet dbResult) {
        this.job = job;
        this.id = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"schedule_id");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name");
        this.enabled = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"enabled");
        this.frequencyType = Objects.requireNonNull((FrequencyType)JDBCUtils.safeGetEnum((ResultSet)dbResult, (String)"freq_type", FrequencyType.class));
        this.frequencySubdayType = this.frequencyType.hasInterval() ? (FrequencySubdayType)JDBCUtils.safeGetEnum((ResultSet)dbResult, (String)"freq_subday_type", FrequencySubdayType.class) : null;
        this.frequencyInterval = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"freq_interval");
        this.frequencyRelativeInterval = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"freq_relative_interval");
        this.frequencyDayInterval = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"freq_subday_interval");
        this.frequencyRecurrenceFactor = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"freq_recurrence_factor");
        this.startDateTime = Objects.requireNonNull(JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"active_start")).toLocalDateTime();
        this.endDateTime = Objects.requireNonNull(JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"active_end")).toLocalDateTime();
        this.description = this.formatDescription();
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2, length=PropertyLength.MULTILINE)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Property(viewable=true, order=3)
    public boolean isEnabled() {
        return this.enabled;
    }

    public long getObjectId() {
        return this.id;
    }

    public boolean isPersisted() {
        return true;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.job;
    }

    @NotNull
    public SQLServerDataSource getDataSource() {
        return this.job.getDataSource();
    }

    @Nullable
    public SQLServerDatabase getDatabase() {
        return null;
    }

    @NotNull
    public DBSObjectState getObjectState() {
        return this.enabled ? DBSObjectState.ACTIVE : DBSObjectState.NORMAL;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) {
    }

    @NotNull
    private String formatDescription() {
        StringBuilder sb = new StringBuilder("Occurs");
        switch (this.frequencyType) {
            case ONE_TIME_ONLY: {
                sb.append(" on ").append(this.startDateTime.format(DATE_FORMATTER)).append(" at ").append(this.startDateTime.format(TIME_FORMATTER));
                break;
            }
            case DAILY: {
                sb.append(" every ").append(this.formatCount("day", this.frequencyInterval));
                break;
            }
            case WEEKLY: {
                sb.append(" every ").append(this.formatCount("week", this.frequencyRecurrenceFactor));
                StringJoiner days = new StringJoiner(", ");
                if (CommonUtils.isBitSet((int)this.frequencyInterval, (int)2)) {
                    days.add("Monday");
                }
                if (CommonUtils.isBitSet((int)this.frequencyInterval, (int)4)) {
                    days.add("Tuesday");
                }
                if (CommonUtils.isBitSet((int)this.frequencyInterval, (int)8)) {
                    days.add("Wednesday");
                }
                if (CommonUtils.isBitSet((int)this.frequencyInterval, (int)16)) {
                    days.add("Thursday");
                }
                if (CommonUtils.isBitSet((int)this.frequencyInterval, (int)32)) {
                    days.add("Friday");
                }
                if (CommonUtils.isBitSet((int)this.frequencyInterval, (int)64)) {
                    days.add("Saturday");
                }
                if (CommonUtils.isBitSet((int)this.frequencyInterval, (int)1)) {
                    days.add("Sunday");
                }
                sb.append(" on ").append(days);
                break;
            }
            case MONTHLY: {
                sb.append(" every ").append(this.formatCount("month", this.frequencyRecurrenceFactor));
                sb.append(" on day ").append(this.frequencyInterval).append(" of that month");
                break;
            }
            case MONTHLY_RELATIVE: {
                sb.append(" every ");
                switch (this.frequencyRelativeInterval) {
                    case 1: {
                        sb.append("first");
                        break;
                    }
                    case 2: {
                        sb.append("second");
                        break;
                    }
                    case 4: {
                        sb.append("third");
                        break;
                    }
                    case 8: {
                        sb.append("fourth");
                        break;
                    }
                    case 16: {
                        sb.append("last");
                        break;
                    }
                }
                sb.append(" ");
                switch (this.frequencyInterval) {
                    case 1: {
                        sb.append("Sunday");
                        break;
                    }
                    case 2: {
                        sb.append("Monday");
                        break;
                    }
                    case 3: {
                        sb.append("Tuesday");
                        break;
                    }
                    case 4: {
                        sb.append("Wednesday");
                        break;
                    }
                    case 5: {
                        sb.append("Thursday");
                        break;
                    }
                    case 6: {
                        sb.append("Friday");
                        break;
                    }
                    case 7: {
                        sb.append("Saturday");
                        break;
                    }
                    case 8: {
                        sb.append("day");
                        break;
                    }
                    case 9: {
                        sb.append("weekday");
                        break;
                    }
                    case 10: {
                        sb.append("weekend");
                        break;
                    }
                }
                sb.append(" of every ").append(this.formatCount("month", this.frequencyRecurrenceFactor));
                break;
            }
            case ON_SERVICE_START: {
                sb.append(" when agent service starts");
                break;
            }
            case ON_COMPUTER_IDLE: {
                sb.append(" whenever the CPUs become idle");
                break;
            }
        }
        if (this.frequencyType.hasInterval()) {
            switch (this.frequencySubdayType) {
                case SPECIFIED_TIME: {
                    sb.append(" at ").append(this.startDateTime.format(TIME_FORMATTER));
                    break;
                }
                case SECONDS: {
                    sb.append(" every ").append(this.formatCount("second", this.frequencyDayInterval));
                    break;
                }
                case MINUTES: {
                    sb.append(" every ").append(this.formatCount("minute", this.frequencyDayInterval));
                    break;
                }
                case HOURS: {
                    sb.append(" every ").append(this.formatCount("hour", this.frequencyDayInterval));
                    break;
                }
            }
            if (this.frequencySubdayType.hasDuration()) {
                sb.append(" between ").append(this.startDateTime.format(TIME_FORMATTER)).append(" and ").append(this.endDateTime.format(TIME_FORMATTER));
            }
            sb.append(". \nSchedule will be used ");
            if (this.endDateTime.toLocalDate().isBefore(LocalDate.of(9999, 12, 31))) {
                sb.append("between ").append(this.startDateTime.format(DATE_FORMATTER)).append(" and ").append(this.endDateTime.format(DATE_FORMATTER));
            } else {
                sb.append("starting on ").append(this.startDateTime.format(DATE_FORMATTER));
            }
        }
        return sb.append(".").toString();
    }

    @NotNull
    private String formatCount(@NotNull String name, int count) {
        if (count == 1) {
            return name;
        }
        return count + " " + name + "(s)";
    }

    private static enum FrequencySubdayType implements DBPEnumWithValue
    {
        SPECIFIED_TIME(1, false),
        SECONDS(2, true),
        MINUTES(4, true),
        HOURS(8, true);

        private final int value;
        private final boolean hasDuration;

        private FrequencySubdayType(int value, boolean hasDuration) {
            this.value = value;
            this.hasDuration = hasDuration;
        }

        public int getValue() {
            return this.value;
        }

        public boolean hasDuration() {
            return this.hasDuration;
        }
    }

    private static enum FrequencyType implements DBPEnumWithValue
    {
        ONE_TIME_ONLY(1, false),
        DAILY(4, true),
        WEEKLY(8, true),
        MONTHLY(16, true),
        MONTHLY_RELATIVE(32, true),
        ON_SERVICE_START(64, false),
        ON_COMPUTER_IDLE(128, false);

        private final int value;
        private final boolean hasInterval;

        private FrequencyType(int value, boolean hasInterval) {
            this.value = value;
            this.hasInterval = hasInterval;
        }

        public int getValue() {
            return this.value;
        }

        public boolean hasInterval() {
            return this.hasInterval;
        }
    }
}

