/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.Immutable;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.HexUtils;
import com.sap.db.util.UUIDUtils;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

@Immutable
public class SAPPassport {
    public static final String PASSPORT_VARIABLE_NAME = "SAP_PASSPORT";
    private static final int PASSPORT_MIN_BYTE_LENGTH = 226;
    private static final int PREV_COMP_NAME_BYTE_OFFSET = 117;
    private static final int PREV_COMP_NAME_MAX_BYTE_LENGTH = 32;
    private static final int ROOT_CONTEXT_ID_BYTE_OFFSET = 186;
    private static final int ROOT_CONTEXT_ID_BYTE_LENGTH = 16;
    private static final int CONN_ID_BYTE_OFFSET = 202;
    private static final int CONN_ID_BYTE_LENGTH = 16;
    private static final int CONN_COUNTER_BYTE_OFFSET = 218;
    private static final int CONN_COUNTER_BYTE_LENGTH = 4;
    private static final int PASSPORT_MIN_HEX_LENGTH = 452;
    private static final int PREV_COMP_NAME_HEX_OFFSET = 234;
    private static final int PREV_COMP_NAME_MAX_HEX_LENGTH = 64;
    private static final int ROOT_CONTEXT_ID_HEX_OFFSET = 372;
    private static final int ROOT_CONTEXT_ID_HEX_LENGTH = 32;
    private static final int CONN_ID_HEX_OFFSET = 404;
    private static final int CONN_ID_HEX_LENGTH = 32;
    private static final int CONN_COUNTER_HEX_OFFSET = 436;
    private static final int CONN_COUNTER_HEX_LENGTH = 8;
    private final byte[] _inboundBytes;
    private final String _inboundHexString;
    private final byte[] _outboundBytes;
    private final String _outboundHexString;

    static SAPPassport newInstance(byte[] inboundBytes, byte[] componentNameBytes, UUID connectionUUID) {
        byte[] outboundBytes = (byte[])inboundBytes.clone();
        int componentNameLen = componentNameBytes.length;
        ByteUtils.putBytes(componentNameBytes, 0, componentNameLen, outboundBytes, 117);
        int n = 149;
        for (int idx = 117 + componentNameLen; idx < n; ++idx) {
            ByteUtils.putByte(32, outboundBytes, idx);
        }
        ByteUtils.putBytes(UUIDUtils.getBytes(connectionUUID), outboundBytes, 202);
        String outboundHexString = HexUtils.toHexString(outboundBytes, true);
        return new SAPPassport(inboundBytes, null, outboundBytes, outboundHexString);
    }

    static SAPPassport newInstance(String inboundHexString, byte[] componentNameBytes, UUID connectionUUID) {
        int componentNameLen = componentNameBytes.length;
        StringBuilder builder = new StringBuilder(452);
        builder.append(inboundHexString, 0, 234);
        builder.append(HexUtils.toHexString(componentNameBytes, true));
        for (int idx = componentNameLen; idx < 32; ++idx) {
            builder.append("20");
        }
        builder.append(inboundHexString, 298, 404);
        builder.append(HexUtils.toHexString(UUIDUtils.getBytes(connectionUUID), true));
        builder.append(inboundHexString, 436, inboundHexString.length());
        String outboundHexString = builder.toString();
        return new SAPPassport(null, inboundHexString, null, outboundHexString);
    }

    static void validateInbound(byte[] inboundBytes) {
        if (inboundBytes == null) {
            throw new IllegalArgumentException("passport is null");
        }
        if (inboundBytes.length < 226) {
            throw new IllegalArgumentException("passport is too short (must be >= 226 bytes)");
        }
    }

    static void validateInbound(String inboundHexString) {
        if (inboundHexString == null) {
            throw new IllegalArgumentException("passport is null");
        }
        if (inboundHexString.length() < 452) {
            throw new IllegalArgumentException("passport is too short (must be >= 452 hex chars)");
        }
    }

    static byte[] validateComponentName(String componentName) {
        if (componentName == null) {
            throw new IllegalArgumentException("component name is null");
        }
        if (componentName.isEmpty()) {
            throw new IllegalArgumentException("component name is empty");
        }
        byte[] componentNameBytes = componentName.getBytes(StandardCharsets.UTF_8);
        if (componentNameBytes.length > 32) {
            throw new IllegalArgumentException("component name is too long (must be <= 32 bytes in UTF-8)");
        }
        return componentNameBytes;
    }

    public static void updatePacket(int connectionCounter, byte[] packet, int offset) {
        int off = offset + 436;
        int v0 = (byte)(connectionCounter >> 24) & 0xFF;
        int v1 = (byte)(connectionCounter >> 16) & 0xFF;
        int v2 = (byte)(connectionCounter >> 8) & 0xFF;
        int v3 = (byte)connectionCounter & 0xFF;
        packet[off++] = (byte)HexUtils.HEXARRAY_UPPER[v0 >>> 4];
        packet[off++] = (byte)HexUtils.HEXARRAY_UPPER[v0 & 0xF];
        packet[off++] = (byte)HexUtils.HEXARRAY_UPPER[v1 >>> 4];
        packet[off++] = (byte)HexUtils.HEXARRAY_UPPER[v1 & 0xF];
        packet[off++] = (byte)HexUtils.HEXARRAY_UPPER[v2 >>> 4];
        packet[off++] = (byte)HexUtils.HEXARRAY_UPPER[v2 & 0xF];
        packet[off++] = (byte)HexUtils.HEXARRAY_UPPER[v3 >>> 4];
        packet[off++] = (byte)HexUtils.HEXARRAY_UPPER[v3 & 0xF];
    }

    SAPPassport(byte[] inboundBytes, String inboundHexString, byte[] outboundBytes, String outboundHexString) {
        this._inboundBytes = inboundBytes;
        this._inboundHexString = inboundHexString;
        this._outboundBytes = outboundBytes;
        this._outboundHexString = outboundHexString;
    }

    public byte[] getInboundBytes() {
        return this._inboundBytes;
    }

    public String getInboundHexString() {
        return this._inboundHexString;
    }

    public byte[] getOutboundBytes() {
        return this._outboundBytes;
    }

    public String getOutboundHexString() {
        return this._outboundHexString;
    }

    public String getRootContextIdHexString() {
        return this._outboundHexString.substring(372, 404);
    }

    public String getConnectionIdHexString() {
        return this._outboundHexString.substring(404, 436);
    }

    public String generateOutboundHexString(int connectionCounter) {
        int v0 = (byte)(connectionCounter >> 24) & 0xFF;
        int v1 = (byte)(connectionCounter >> 16) & 0xFF;
        int v2 = (byte)(connectionCounter >> 8) & 0xFF;
        int v3 = (byte)connectionCounter & 0xFF;
        return this._outboundHexString.substring(0, 436) + HexUtils.HEXARRAY_UPPER[v0 >>> 4] + HexUtils.HEXARRAY_UPPER[v0 & 0xF] + HexUtils.HEXARRAY_UPPER[v1 >>> 4] + HexUtils.HEXARRAY_UPPER[v1 & 0xF] + HexUtils.HEXARRAY_UPPER[v2 >>> 4] + HexUtils.HEXARRAY_UPPER[v2 & 0xF] + HexUtils.HEXARRAY_UPPER[v3 >>> 4] + HexUtils.HEXARRAY_UPPER[v3 & 0xF] + this._outboundHexString.substring(444);
    }
}

