/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.PassportListener;
import com.sap.db.jdbc.ServerKPIs;
import com.sap.db.jdbc.packet.HOptionsPart;
import com.sap.db.util.Dbg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@NotThreadSafe
public class APIMetrics {
    private static final ThreadLocal<APIMetrics> API_METRICS = ThreadLocal.withInitial(APIMetrics::new);
    private final ServerKPIs _serverKPIs = new ServerKPIs();
    private final List<PassportListener.PacketInfo> _packetInfos = new ArrayList<PassportListener.PacketInfo>();
    private int _apiDepth;
    private long _apiStartTime = -1L;
    private long _elapsedAPITime;
    private long _elapsedNetworkTime;
    private long _elapsedTotalTime;

    public static APIMetrics getInstance() {
        return API_METRICS.get();
    }

    private APIMetrics() {
    }

    public boolean isValid() {
        return this._apiDepth == 0 && this._apiStartTime == 0L;
    }

    public boolean isNested() {
        return this._apiDepth > 0 && this._apiStartTime > 0L;
    }

    public long getElapsedAPITime() {
        return this._elapsedAPITime;
    }

    public long getElapsedNetworkTime() {
        return this._elapsedNetworkTime;
    }

    public long getElapsedTotalTime() {
        return this._elapsedTotalTime;
    }

    public long getServerProcessingTime() {
        return this._serverKPIs.getServerProcessingTime();
    }

    public long getServerCPUTime() {
        return this._serverKPIs.getServerCPUTime();
    }

    public long getServerMemoryUsage() {
        return this._serverKPIs.getServerMemoryUsage();
    }

    public void apiStart() {
        this._apiStart();
    }

    public void apiFinish() {
        this._apiFinish(true, null);
        if (Dbg.runtimeEnabled && this._elapsedNetworkTime > 0L) {
            throw new AssertionError((Object)("An unexpected packet exchange occurred during an JDBC API call: " + this._getDebugInvocationSourceString()));
        }
    }

    public void apiFinish(boolean aon, PassportListener passportListener) {
        this._apiFinish(aon, passportListener);
    }

    public void accumulateNetworkTime(long networkTime) {
        this._elapsedNetworkTime += networkTime;
    }

    public void accumulateServerKPIs(HOptionsPart statementContextPart) {
        this._serverKPIs.accumulate(statementContextPart);
    }

    public void handleReceivedPacket(PassportListener passportListener, PassportListener.PacketInfo packetInfo) {
        if (this._apiDepth == 0) {
            passportListener.log(0L, this._elapsedNetworkTime, this._elapsedNetworkTime, Collections.singletonList(packetInfo));
            this._elapsedNetworkTime = 0L;
            return;
        }
        this._packetInfos.add(packetInfo);
    }

    private void _apiStart() {
        if (this._apiDepth++ > 0) {
            return;
        }
        this._apiStartTime = System.nanoTime();
        this._elapsedAPITime = 0L;
        this._elapsedNetworkTime = 0L;
        this._elapsedTotalTime = 0L;
        this._serverKPIs.reset();
        this._packetInfos.clear();
    }

    private void _apiFinish(boolean aon, PassportListener passportListener) {
        boolean hasPackets;
        if (--this._apiDepth > 0) {
            return;
        }
        boolean bl = hasPackets = !this._packetInfos.isEmpty();
        if (!aon && !hasPackets) {
            return;
        }
        this._elapsedTotalTime = System.nanoTime() - this._apiStartTime;
        this._elapsedAPITime = this._elapsedTotalTime - this._elapsedNetworkTime;
        this._apiStartTime = 0L;
        if (passportListener != null && hasPackets) {
            passportListener.log(this._elapsedAPITime, this._elapsedNetworkTime, this._elapsedTotalTime, new ArrayList<PassportListener.PacketInfo>(this._packetInfos));
        }
    }

    private String _getDebugInvocationSourceString() {
        StackTraceElement[] stes = Thread.currentThread().getStackTrace();
        StackTraceElement ste = stes[3];
        String className = ste.getClassName();
        String methodName = ste.getMethodName();
        if (className.equals("com.sap.db.jdbc.ConnectionSapDB") && (methodName.equals("apiStart") || methodName.equals("apiFinish"))) {
            ste = stes[4];
            className = ste.getClassName();
            methodName = ste.getMethodName();
        }
        return this._apiDepth + " " + className + "." + methodName;
    }

    static boolean isTracking() {
        return APIMetrics.API_METRICS.get()._apiStartTime != -1L;
    }

    static void reset() {
        API_METRICS.remove();
    }
}

