/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.FromItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.JoinHint;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.KSQLJoinWindow;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;

public class Join
extends ASTNodeAccessImpl {
    private boolean outer = false;
    private boolean right = false;
    private boolean left = false;
    private boolean natural = false;
    private boolean global = false;
    private boolean full = false;
    private boolean inner = false;
    private boolean simple = false;
    private boolean cross = false;
    private boolean semi = false;
    private boolean straight = false;
    private boolean apply = false;
    private FromItem fromItem;
    private final LinkedList<Expression> onExpressions = new LinkedList();
    private final LinkedList<Column> usingColumns = new LinkedList();
    private KSQLJoinWindow joinWindow;
    private JoinHint joinHint = null;

    public boolean isSimple() {
        return this.simple;
    }

    public Join withSimple(boolean b) {
        this.setSimple(b);
        return this;
    }

    public void setSimple(boolean b) {
        this.simple = b;
    }

    public boolean isInnerJoin() {
        return this.inner || !this.left && !this.right && !this.full && !this.outer && !this.cross && !this.natural;
    }

    public boolean isInner() {
        return this.inner;
    }

    public Join withInner(boolean b) {
        this.setInner(b);
        return this;
    }

    public void setInner(boolean b) {
        if (b) {
            this.left = false;
            this.right = false;
            this.outer = false;
            this.cross = false;
            this.natural = false;
        }
        this.inner = b;
    }

    public boolean isStraight() {
        return this.straight;
    }

    public Join withStraight(boolean b) {
        this.setStraight(b);
        return this;
    }

    public void setStraight(boolean b) {
        this.straight = b;
    }

    public boolean isOuter() {
        return this.outer;
    }

    public Join withOuter(boolean b) {
        this.setOuter(b);
        return this;
    }

    public void setOuter(boolean b) {
        if (b) {
            this.inner = false;
        }
        this.outer = b;
    }

    public boolean isApply() {
        return this.apply;
    }

    public Join withApply(boolean apply) {
        this.setApply(apply);
        return this;
    }

    public void setApply(boolean apply) {
        this.apply = apply;
    }

    public boolean isSemi() {
        return this.semi;
    }

    public Join withSemi(boolean b) {
        this.setSemi(b);
        return this;
    }

    public void setSemi(boolean b) {
        this.semi = b;
    }

    public boolean isLeft() {
        return this.left;
    }

    public Join withLeft(boolean b) {
        this.setLeft(b);
        return this;
    }

    public void setLeft(boolean b) {
        if (b) {
            this.inner = false;
            this.right = false;
        }
        this.left = b;
    }

    public boolean isRight() {
        return this.right;
    }

    public Join withRight(boolean b) {
        this.setRight(b);
        return this;
    }

    public void setRight(boolean b) {
        if (b) {
            this.inner = false;
            this.left = false;
        }
        this.right = b;
    }

    public boolean isNatural() {
        return this.natural;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public Join withNatural(boolean b) {
        this.setNatural(b);
        return this;
    }

    public void setNatural(boolean b) {
        this.natural = b;
    }

    public void setGlobal(boolean b) {
        this.global = b;
    }

    public boolean isFull() {
        return this.full;
    }

    public Join withFull(boolean b) {
        this.setFull(b);
        return this;
    }

    public void setFull(boolean b) {
        this.full = b;
    }

    public boolean isCross() {
        return this.cross;
    }

    public Join withCross(boolean cross) {
        this.setCross(cross);
        return this;
    }

    public void setCross(boolean cross) {
        this.cross = cross;
    }

    public FromItem getRightItem() {
        return this.fromItem;
    }

    @Deprecated
    public Join withRightItem(FromItem item) {
        this.setFromItem(item);
        return this;
    }

    public void setRightItem(FromItem item) {
        this.fromItem = item;
    }

    public FromItem getFromItem() {
        return this.fromItem;
    }

    public Join setFromItem(FromItem fromItem) {
        this.fromItem = fromItem;
        return this;
    }

    @Deprecated
    public Expression getOnExpression() {
        return this.onExpressions.get(0);
    }

    public Collection<Expression> getOnExpressions() {
        return this.onExpressions;
    }

    @Deprecated
    public Join withOnExpression(Expression expression) {
        this.setOnExpression(expression);
        return this;
    }

    @Deprecated
    public void setOnExpression(Expression expression) {
        this.onExpressions.add(0, expression);
    }

    public Join addOnExpression(Expression expression) {
        this.onExpressions.add(expression);
        return this;
    }

    public Join setOnExpressions(Collection<Expression> expressions) {
        this.onExpressions.clear();
        this.onExpressions.addAll(expressions);
        return this;
    }

    public List<Column> getUsingColumns() {
        return this.usingColumns;
    }

    public Join withUsingColumns(List<Column> list) {
        this.setUsingColumns(list);
        return this;
    }

    public void setUsingColumns(List<Column> list) {
        this.usingColumns.clear();
        this.usingColumns.addAll(list);
    }

    public boolean isWindowJoin() {
        return this.joinWindow != null;
    }

    public KSQLJoinWindow getJoinWindow() {
        return this.joinWindow;
    }

    public Join withJoinWindow(KSQLJoinWindow joinWindow) {
        this.setJoinWindow(joinWindow);
        return this;
    }

    public void setJoinWindow(KSQLJoinWindow joinWindow) {
        this.joinWindow = joinWindow;
    }

    public JoinHint getJoinHint() {
        return this.joinHint;
    }

    public Join setJoinHint(JoinHint joinHint) {
        this.joinHint = joinHint;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isGlobal()) {
            builder.append("GLOBAL ");
        }
        if (this.isSimple() && this.isOuter()) {
            builder.append("OUTER ").append(this.fromItem);
        } else if (this.isSimple()) {
            builder.append(this.fromItem);
        } else {
            if (this.isNatural()) {
                builder.append("NATURAL ");
            }
            if (this.isRight()) {
                builder.append("RIGHT ");
            } else if (this.isFull()) {
                builder.append("FULL ");
            } else if (this.isLeft()) {
                builder.append("LEFT ");
            } else if (this.isCross()) {
                builder.append("CROSS ");
            }
            if (this.isOuter()) {
                builder.append("OUTER ");
            } else if (this.isInner()) {
                builder.append("INNER ");
            } else if (this.isSemi()) {
                builder.append("SEMI ");
            }
            if (this.isStraight()) {
                builder.append("STRAIGHT_JOIN ");
            } else if (this.isApply()) {
                builder.append("APPLY ");
            } else {
                if (this.joinHint != null) {
                    builder.append(this.joinHint).append(" ");
                }
                builder.append("JOIN ");
            }
            builder.append(this.fromItem).append(this.joinWindow != null ? " WITHIN " + this.joinWindow : "");
        }
        for (Expression onExpression : this.onExpressions) {
            builder.append(" ON ").append(onExpression);
        }
        if (this.usingColumns.size() > 0) {
            builder.append(PlainSelect.getFormattedList(this.usingColumns, "USING", true, true));
        }
        return builder.toString();
    }

    public Join addUsingColumns(Column ... usingColumns) {
        List collection = Optional.ofNullable(this.getUsingColumns()).orElseGet(ArrayList::new);
        Collections.addAll(collection, usingColumns);
        return this.withUsingColumns(collection);
    }

    public Join addUsingColumns(Collection<? extends Column> usingColumns) {
        List collection = Optional.ofNullable(this.getUsingColumns()).orElseGet(ArrayList::new);
        collection.addAll(usingColumns);
        return this.withUsingColumns(collection);
    }
}

