/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.com.github.difflib.unifieddiff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import liquibase.repackaged.com.github.difflib.patch.PatchFailedException;
import liquibase.repackaged.com.github.difflib.unifieddiff.UnifiedDiffFile;

public final class UnifiedDiff {
    private String header;
    private String tail;
    private final List<UnifiedDiffFile> files = new ArrayList<UnifiedDiffFile>();

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    void addFile(UnifiedDiffFile file) {
        this.files.add(file);
    }

    public List<UnifiedDiffFile> getFiles() {
        return Collections.unmodifiableList(this.files);
    }

    void setTailTxt(String tailTxt) {
        this.tail = tailTxt;
    }

    public String getTail() {
        return this.tail;
    }

    public List<String> applyPatchTo(Predicate<String> findFile, List<String> originalLines) throws PatchFailedException {
        UnifiedDiffFile file = this.files.stream().filter(diff -> findFile.test(diff.getFromFile())).findFirst().orElse(null);
        if (file != null) {
            return file.getPatch().applyTo(originalLines);
        }
        return originalLines;
    }

    public static UnifiedDiff from(String header, String tail, UnifiedDiffFile ... files) {
        UnifiedDiff diff = new UnifiedDiff();
        diff.setHeader(header);
        diff.setTailTxt(tail);
        for (UnifiedDiffFile file : files) {
            diff.addFile(file);
        }
        return diff;
    }
}

