/*
 * Decompiled with CFR 0.152.
 */
package liquibase.configuration.pro;

import java.util.Collections;
import java.util.List;
import liquibase.Scope;
import liquibase.configuration.ConfigurationDefinition;
import liquibase.configuration.ConfiguredValue;
import liquibase.configuration.ConfiguredValueModifier;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.configuration.ProvidedValue;
import liquibase.configuration.pro.UnlicensedVariableFactory;
import liquibase.license.LicenseServiceUtils;
import liquibase.util.CollectionUtil;
import liquibase.util.StringUtil;

public abstract class ProConfiguredValueModifier<DataType>
implements ConfiguredValueModifier<DataType> {
    public final void override(ConfiguredValue<DataType> object) {
        ProvidedValue finalValue = object.getProvidedValue();
        String finalValueString = null;
        if (finalValue != null && finalValue.getValue() != null) {
            finalValueString = finalValue.getValue().toString().toLowerCase();
        }
        if (StringUtil.isEmpty(finalValueString) || !finalValueString.startsWith(this.getProviderPrefix() + ",")) {
            if (StringUtil.isNotEmpty(finalValueString) && finalValueString.contains(this.getProviderPrefix())) {
                Scope.getCurrentScope().getLog(this.getClass()).warning("The property " + object.getProvidedValue().getRequestedKey() + " contains the keyword " + this.getProviderPrefix() + " but the plugin is not being used to decrypt this value.");
            }
            return;
        }
        ConfigurationDefinition config = ((LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class)).getRegisteredDefinition(object.getProvidedValue().getRequestedKey());
        if (CollectionUtil.createIfNull(this.getIllegalLookupConfigs()).contains(config)) {
            throw new IllegalArgumentException("It is not possible to lookup the value for " + object.getProvidedValue().getActualKey() + " using the " + this.getName() + " plugin. Try setting the value for this configuration value using another mechanism, like environment variables.");
        }
        UnlicensedVariableFactory unlicensedVariableFactory = (UnlicensedVariableFactory)Scope.getCurrentScope().getSingleton(UnlicensedVariableFactory.class);
        if (!unlicensedVariableFactory.isUnlicensed(config) && !LicenseServiceUtils.isProLicenseValid()) {
            throw new IllegalArgumentException(this.getUnlicensedExceptionMessage());
        }
        this.internalOverride(object);
    }

    protected String getUnlicensedExceptionMessage() {
        return "Pro License Key required for " + this.getName() + " extension";
    }

    public abstract void internalOverride(ConfiguredValue<DataType> var1);

    public abstract String getName();

    public abstract String getProviderPrefix();

    public List<ConfigurationDefinition<?>> getIllegalLookupConfigs() {
        return Collections.emptyList();
    }

    public int getOrder() {
        return 100;
    }
}

