/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Optional;
import java.util.Properties;
import liquibase.Scope;

public class ProConfigurationUtil {
    public static Optional<String> getLiquibaseBuildProperty(String key) {
        Properties liquibaseBuildProperties = new Properties();
        try {
            Enumeration<URL> propertiesUrls = Scope.getCurrentScope().getClassLoader().getResources("liquibase.build.properties");
            while (propertiesUrls.hasMoreElements()) {
                URL url = propertiesUrls.nextElement();
                InputStream buildProperties = url.openStream();
                Throwable throwable = null;
                try {
                    if (buildProperties == null) continue;
                    liquibaseBuildProperties.load(buildProperties);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (buildProperties == null) continue;
                    if (throwable != null) {
                        try {
                            buildProperties.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    buildProperties.close();
                }
            }
        }
        catch (IOException e) {
            Scope.getCurrentScope().getLog(ProConfigurationUtil.class).severe("Cannot read liquibase.build.properties", (Throwable)e);
        }
        return Optional.ofNullable(liquibaseBuildProperties.getProperty(key));
    }
}

