/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger;

import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import com.datical.liquibase.ext.storedlogic.trigger.MissingTriggerChangeGenerator;
import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.datical.liquibase.ext.storedlogic.trigger.change.CreateTriggerChange;
import com.datical.liquibase.ext.util.ObjectSqlFileUtil;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.license.LicenseServiceUtils;
import liquibase.servicelocator.LiquibaseService;
import liquibase.structure.DatabaseObject;

@LiquibaseService
public class MissingTriggerExternalFileChangeGenerator
extends MissingTriggerChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (!((Boolean)LiquibaseProConfiguration.INLINE_SQL_KEY.getCurrentValue()).booleanValue() && Trigger.class.isAssignableFrom(objectType)) {
            if (!LicenseServiceUtils.isProLicenseValid()) {
                return -1;
            }
            return super.getPriority(objectType, database) + 100;
        }
        return -1;
    }

    @Override
    public Change[] fixMissing(DatabaseObject databaseObject, DiffOutputControl diffOutputControl, Database database, Database database2, ChangeGeneratorChain changeGeneratorChain) {
        Change[] changes = super.fixMissing(databaseObject, diffOutputControl, database, database2, changeGeneratorChain);
        CreateTriggerChange change = MissingTriggerExternalFileChangeGenerator.findChange(CreateTriggerChange.class, changes);
        change.setRelativeToChangelogFile(true);
        Trigger trigger = (Trigger)databaseObject;
        String relativePath = trigger.getTableName();
        if (relativePath != null) {
            relativePath = "trigger/" + relativePath + "_" + trigger.getName() + ".sql";
        }
        change.setPath(ObjectSqlFileUtil.writeObjectSql((DatabaseObject)trigger, trigger.getBody(), relativePath));
        change.setTriggerBody(null);
        return changes;
    }
}

