/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger;

import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import com.datical.liquibase.ext.storedlogic.trigger.ChangedTriggerChangeGenerator;
import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.datical.liquibase.ext.storedlogic.trigger.change.CreateTriggerChange;
import com.datical.liquibase.ext.util.ObjectSqlFileUtil;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.license.LicenseServiceUtils;
import liquibase.servicelocator.LiquibaseService;
import liquibase.structure.DatabaseObject;

@LiquibaseService
public class ChangedTriggerExternalFileChangeGenerator
extends ChangedTriggerChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (!((Boolean)LiquibaseProConfiguration.INLINE_SQL_KEY.getCurrentValue()).booleanValue() && Trigger.class.isAssignableFrom(objectType)) {
            if (!LicenseServiceUtils.isProLicenseValid()) {
                return -1;
            }
            return super.getPriority(objectType, database) + 100;
        }
        return -1;
    }

    @Override
    public Change[] fixChanged(DatabaseObject databaseObject, ObjectDifferences objectDifferences, DiffOutputControl diffOutputControl, Database database, Database database2, ChangeGeneratorChain changeGeneratorChain) {
        Change[] changes = super.fixChanged(databaseObject, objectDifferences, diffOutputControl, database, database2, changeGeneratorChain);
        if (changes == null || changes.length == 0) {
            return null;
        }
        for (Change anyChange : changes) {
            if (!(anyChange instanceof CreateTriggerChange)) continue;
            CreateTriggerChange change = (CreateTriggerChange)anyChange;
            change.setRelativeToChangelogFile(true);
            change.setPath(ObjectSqlFileUtil.writeObjectSql((Trigger)databaseObject));
            change.setTriggerBody(null);
        }
        return changes;
    }
}

