/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.function.change;

import com.datical.liquibase.ext.storedlogic.function.Function;
import com.datical.liquibase.ext.storedlogic.function.change.DropFunctionStatement;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.core.SnowflakeDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import org.apache.commons.lang3.StringUtils;

public class DropFunctionGenerator
extends AbstractSqlGenerator<DropFunctionStatement> {
    public ValidationErrors validate(DropFunctionStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("functionName", (Object)statement.getFunctionName());
        validationErrors.checkDisallowedField("catalogName", (Object)statement.getCatalogName(), database, new Class[]{MSSQLDatabase.class});
        return validationErrors;
    }

    public Sql[] generateSql(DropFunctionStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String fullFunctionName = database.escapeObjectName(statement.getCatalogName(), statement.getSchemaName(), statement.getFunctionName(), Function.class);
        if (database instanceof PostgresDatabase || database instanceof SnowflakeDatabase) {
            String schemaName;
            String string = schemaName = statement.getSchemaName() == null ? database.getDefaultSchemaName() : statement.getSchemaName();
            if (schemaName != null) {
                fullFunctionName = database.escapeObjectName(schemaName, Schema.class) + "." + database.escapeObjectName(statement.getFunctionName(), Function.class);
            }
            if (database instanceof SnowflakeDatabase || !DropFunctionGenerator.supportsUniqueFunctionDrop(database)) {
                fullFunctionName = fullFunctionName + "()";
            }
            if (database instanceof PostgresDatabase && StringUtils.isNotEmpty((CharSequence)statement.getArguments())) {
                fullFunctionName = fullFunctionName + String.format("(%s)", statement.getArguments());
            }
        }
        UnparsedSql generatedSql = new UnparsedSql("DROP FUNCTION " + fullFunctionName, new DatabaseObject[]{((Function)new Function().setName(statement.getFunctionName())).setSchema(new Schema(statement.getCatalogName(), statement.getSchemaName()))});
        Sql[] returnSql = new Sql[]{generatedSql};
        return returnSql;
    }

    private static boolean supportsUniqueFunctionDrop(Database database) {
        try {
            return database.getDatabaseMajorVersion() > 9;
        }
        catch (Exception ignore) {
            return false;
        }
    }
}

