/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.function.change;

import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.storedlogic.function.change.DropFunctionStatement;
import com.datical.liquibase.ext.util.RefactoringUtils;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.core.SnowflakeDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.statement.SqlStatement;
import lombok.Generated;

@DatabaseChange(name="dropFunction", description="Drops an existing function", priority=101, appliesTo={"function"})
public class DropFunctionChange
extends LicenseValidationChange {
    private String catalogName;
    private String schemaName;
    private String functionName;
    private String arguments;

    public boolean supports(Database database) {
        return database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof MySQLDatabase || database instanceof AbstractDb2Database || database instanceof PostgresDatabase || database instanceof SnowflakeDatabase;
    }

    @Override
    public ValidationErrors validate(Database database) {
        if (this.supports(database)) {
            return super.validate(database);
        }
        return RefactoringUtils.createValidationErrors(database, (Change)this);
    }

    @DatabaseChangeProperty(mustEqualExisting="function.catalog", description="Name of the database catalog")
    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @DatabaseChangeProperty(mustEqualExisting="function.schema", description="Name of the database schema")
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @DatabaseChangeProperty(mustEqualExisting="function", description="Name of the function to drop")
    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getConfirmationMessage() {
        return "Function " + this.getFunctionName() + " dropped";
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new DropFunctionStatement(this.getCatalogName(), this.getSchemaName(), this.getFunctionName(), this.getArguments())};
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }

    @Generated
    public String getArguments() {
        return this.arguments;
    }

    @Generated
    public void setArguments(String arguments) {
        this.arguments = arguments;
    }
}

