/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.sqlgenerator;

import com.datical.liquibase.ext.config.MySqlConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import liquibase.database.Database;
import liquibase.database.core.MariaDBDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.datatype.DataTypeFactory;
import liquibase.license.LicenseServiceUtils;
import liquibase.sqlgenerator.core.CreateDatabaseChangeLogTableGenerator;
import liquibase.statement.ColumnConstraint;
import liquibase.statement.NotNullConstraint;
import liquibase.statement.core.CreateDatabaseChangeLogTableStatement;
import liquibase.statement.core.CreateTableStatement;

public class ProCreateDatabaseChangeLogTableGenerator
extends CreateDatabaseChangeLogTableGenerator {
    private static final String COMPOSITE_PK_CONSTRAINT_NAME = "DATABASECHANGELOG_PK";
    private static final List<String> PK_COLUMNS_LIST = Arrays.asList("ID", "AUTHOR", "FILENAME");

    public int getPriority() {
        if (LicenseServiceUtils.isProLicenseValid()) {
            return super.getPriority() + 1;
        }
        return -1;
    }

    public boolean supports(CreateDatabaseChangeLogTableStatement statement, Database database) {
        return database instanceof MySQLDatabase && !(database instanceof MariaDBDatabase);
    }

    protected CreateTableStatement getCreateTableStatement(Database database) {
        if (((Boolean)MySqlConfiguration.ENABLE_PRIMARY_KEY.getCurrentValue()).booleanValue()) {
            CreateTableStatement createTableStatement = super.getCreateTableStatement(database);
            String charTypeName = this.getCharTypeName(database);
            ArrayList initialColumns = new ArrayList(createTableStatement.getColumns());
            createTableStatement.getColumns().removeAll(PK_COLUMNS_LIST);
            createTableStatement.addPrimaryKeyColumn("ID", DataTypeFactory.getInstance().fromDescription(charTypeName + "(" + this.getIdColumnSize() + ")", database), null, COMPOSITE_PK_CONSTRAINT_NAME, null, new ColumnConstraint[]{new NotNullConstraint()}).addPrimaryKeyColumn("AUTHOR", DataTypeFactory.getInstance().fromDescription(charTypeName + "(" + this.getAuthorColumnSize() + ")", database), null, COMPOSITE_PK_CONSTRAINT_NAME, null, new ColumnConstraint[]{new NotNullConstraint()}).addPrimaryKeyColumn("FILENAME", DataTypeFactory.getInstance().fromDescription(charTypeName + "(" + this.getFilenameColumnSize() + ")", database), null, COMPOSITE_PK_CONSTRAINT_NAME, null, new ColumnConstraint[]{new NotNullConstraint()});
            for (int i = 0; i < initialColumns.size(); ++i) {
                createTableStatement.getColumns().set(i, initialColumns.get(i));
            }
            return createTableStatement;
        }
        return super.getCreateTableStatement(database);
    }
}

