/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.sqlgenerator;

import com.datical.liquibase.ext.config.DatabaseChangelogHistoryConfiguration;
import com.datical.liquibase.ext.history.DatabaseChangeLogHistoryEntry;
import com.datical.liquibase.ext.history.DatabaseChangeLogHistoryService;
import com.datical.liquibase.ext.history.DatabaseChangeLogHistoryServiceFactory;
import com.datical.liquibase.ext.sqlgenerator.DatabaseChangeLogHistoryColumns;
import com.datical.liquibase.ext.statement.CreateDatabaseChangeLogHistoryTableStatement;
import com.datical.liquibase.ext.statement.InsertDatabaseChangeLogHistoryStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.TempObjectQuotingStrategy;
import liquibase.database.core.DatabaseUtils;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertStatement;
import org.apache.commons.lang3.StringUtils;

public class InsertDatabaseChangeLogHistoryGenerator
extends AbstractSqlGenerator<InsertDatabaseChangeLogHistoryStatement> {
    public ValidationErrors validate(InsertDatabaseChangeLogHistoryStatement statement, Database database, SqlGeneratorChain<InsertDatabaseChangeLogHistoryStatement> sqlGeneratorChain) {
        return new ValidationErrors();
    }

    public Sql[] generateSql(InsertDatabaseChangeLogHistoryStatement statement, Database database, SqlGeneratorChain<InsertDatabaseChangeLogHistoryStatement> sqlGeneratorChain) {
        List<SqlStatement> createHistoryTableStatement;
        ArrayList<Object> statements = new ArrayList<Object>();
        if (this.shouldCreateTable(statement) && (createHistoryTableStatement = this.createHistoryTableIfNotExists(database, statement.isLoggingExecutor())) != null && !createHistoryTableStatement.isEmpty()) {
            statements.addAll(createHistoryTableStatement);
            statement.getDidCreateTable().set(true);
        }
        DatabaseChangeLogHistoryServiceFactory factory = (DatabaseChangeLogHistoryServiceFactory)Scope.getCurrentScope().getSingleton(DatabaseChangeLogHistoryServiceFactory.class);
        DatabaseChangeLogHistoryService service = factory.getService(database);
        DatabaseChangeLogHistoryEntry entry = service.buildEntry(statement.getChangeSet(), statement.getOutcome(), statement.getCommandScope(), database);
        InsertStatement insertStatement = new InsertStatement(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName(), DatabaseChangelogHistoryConfiguration.getTableName(database)).addColumnValue(DatabaseChangeLogHistoryColumns.ID.getColumnName(), (Object)entry.getId()).addColumnValue(DatabaseChangeLogHistoryColumns.AUTHOR.getColumnName(), (Object)entry.getAuthor()).addColumnValue(DatabaseChangeLogHistoryColumns.FILENAME.getColumnName(), (Object)entry.getFilename()).addColumnValue(DatabaseChangeLogHistoryColumns.COMMAND.getColumnName(), (Object)entry.getCommand()).addColumnValue(DatabaseChangeLogHistoryColumns.INTERNAL_COMMAND.getColumnName(), (Object)entry.getInternalCommand()).addColumnValue(DatabaseChangeLogHistoryColumns.ARGUMENTS.getColumnName(), (Object)entry.getArguments()).addColumnValue(DatabaseChangeLogHistoryColumns.OUTCOME.getColumnName(), (Object)entry.getOutcome()).addColumnValue(DatabaseChangeLogHistoryColumns.START.getColumnName(), (Object)entry.getStart()).addColumnValue(DatabaseChangeLogHistoryColumns.END.getColumnName(), (Object)entry.getEnd()).addColumnValue(DatabaseChangeLogHistoryColumns.CONTEXTS.getColumnName(), (Object)entry.getContexts()).addColumnValue(DatabaseChangeLogHistoryColumns.LABELS.getColumnName(), (Object)entry.getLabels()).addColumnValue(DatabaseChangeLogHistoryColumns.MD5SUM.getColumnName(), (Object)entry.getMd5Sum()).addColumnValue(DatabaseChangeLogHistoryColumns.DESCRIPTION.getColumnName(), (Object)entry.getDescription()).addColumnValue(DatabaseChangeLogHistoryColumns.COMMENTS.getColumnName(), (Object)entry.getComments()).addColumnValue(DatabaseChangeLogHistoryColumns.DEPLOYMENT_ID.getColumnName(), (Object)entry.getDeploymentId()).addColumnValue(DatabaseChangeLogHistoryColumns.EXECUTEDSQL.getColumnName(), this.getExecutedSql(entry)).addColumnValue(DatabaseChangeLogHistoryColumns.LIQUIBASEVERSION.getColumnName(), (Object)entry.getLiquibaseVersion()).addColumnValue(DatabaseChangeLogHistoryColumns.HOSTNAME.getColumnName(), (Object)entry.getHostname()).addColumnValue(DatabaseChangeLogHistoryColumns.SYSTEMUSER.getColumnName(), (Object)entry.getSystemUser()).addColumnValue(DatabaseChangeLogHistoryColumns.INTERFACE.getColumnName(), (Object)entry.getIinterface()).addColumnValue(DatabaseChangeLogHistoryColumns.EXTENSIONS.getColumnName(), (Object)entry.getExtensions());
        if (entry.getTag() != null) {
            insertStatement.addColumnValue(DatabaseChangeLogHistoryColumns.TAG.getColumnName(), (Object)entry.getTag());
        }
        statements.add(insertStatement);
        try (TempObjectQuotingStrategy tempObjectQuotingStrategy = database.temporarilySetObjectQuotingStrategy(ObjectQuotingStrategy.LEGACY);){
            Sql[] sqlArray = SqlGeneratorFactory.getInstance().generateSql(statements.toArray(SqlStatement.EMPTY_SQL_STATEMENT), database);
            return sqlArray;
        }
    }

    protected Object getExecutedSql(DatabaseChangeLogHistoryEntry entry) {
        return entry.getExecutedSql();
    }

    private boolean shouldCreateTable(InsertDatabaseChangeLogHistoryStatement statement) {
        return !statement.isLoggingExecutor() || !statement.getDidCreateTable().get();
    }

    private List<SqlStatement> createHistoryTableIfNotExists(Database database, boolean loggingExecutor) {
        try {
            DatabaseChangeLogHistoryServiceFactory factory = (DatabaseChangeLogHistoryServiceFactory)Scope.getCurrentScope().getSingleton(DatabaseChangeLogHistoryServiceFactory.class);
            DatabaseChangeLogHistoryService service = factory.getService(database);
            boolean historyTableExists = service.historyTableExists(database);
            if (!historyTableExists) {
                CreateDatabaseChangeLogHistoryTableStatement createTableStatement = new CreateDatabaseChangeLogHistoryTableStatement();
                String tableName = DatabaseChangelogHistoryConfiguration.getTableName(database);
                String catalog = database.getLiquibaseCatalogName();
                String schema = database.getLiquibaseSchemaName();
                if (!loggingExecutor) {
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Creating database history table with name: " + database.escapeTableName(catalog, schema, tableName));
                    String catalogAndSchema = DatabaseUtils.buildCatalogAndSchemaString((String)catalog, (String)schema);
                    String inMessage = StringUtils.isEmpty((CharSequence)catalogAndSchema) ? "" : " in '" + catalogAndSchema + "'";
                    Scope.getCurrentScope().getUI().sendMessage("INFO: A new table '" + tableName + "' was created" + inMessage + " to track database changing Liquibase operations. The Pro property 'liquibase.dbclhistory.enabled=true' was configured on the CLI, or as Environment Variable or defaults file property, etc. To pause collecting history, set to 'false'. Learn more at " + "https://docs.liquibase.com/DATABASECHANGELOGHISTORY");
                }
                return Collections.singletonList(createTableStatement);
            }
        }
        catch (LiquibaseException e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
        return Collections.emptyList();
    }
}

