/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.flow.condition;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StreamUtil;

public class FlowFileUtil {
    public static boolean exists(String filePath) throws IOException {
        return FlowFileUtil.exists(filePath, true);
    }

    public static boolean exists(String filePath, boolean relativePath) throws IOException {
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        if (!relativePath) {
            return resourceAccessor.get(filePath).exists();
        }
        return new File(filePath).exists();
    }

    public static boolean hasString(String searchString, String filePath, boolean relativePath) throws IOException {
        if (!FlowFileUtil.exists(filePath, relativePath)) {
            return false;
        }
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        Resource resource = resourceAccessor.get(filePath);
        try (InputStream is = resource.openInputStream();){
            String encoding = (String)GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue();
            String contents = StreamUtil.readStreamAsString((InputStream)is, (String)encoding);
            boolean bl = contents.contains(searchString);
            return bl;
        }
    }
}

