/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.helpers;

import com.datical.liquibase.ext.config.ReportConfiguration;
import com.datical.liquibase.ext.reports.ReportArguments;
import com.datical.liquibase.ext.reports.ReportFormat;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.helpers.AbstractArgumentCommandStep;
import liquibase.util.ExceptionUtil;
import org.apache.commons.lang3.StringUtils;

public class ReportCommandArguments
extends AbstractArgumentCommandStep {
    protected static final String[] COMMAND_NAME = new String[]{"report"};
    public static final CommandArgumentDefinition<String> REPORT_NAME;
    public static final CommandArgumentDefinition<String> REPORT_PATH;
    public static final CommandArgumentDefinition<Boolean> REPORT_ENABLED;
    public static final CommandArgumentDefinition<ReportFormat> REPORT_FORMAT;
    private static final CommandArgumentDefinition<Boolean> SUPPRESS_SQL;
    private static final CommandArgumentDefinition<Boolean> SUPPRESS_EXCEPTION;
    public static final String DEFAULT_REPORT_NAME_DATE_FORMAT = "dd-MMM-yyyy-HHmmss";
    public static final String REPORT_NAME_EXAMPLE;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public List<Class<?>> providedDependencies() {
        return Collections.singletonList(ReportCommandArguments.class);
    }

    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        Boolean suppressException;
        Boolean suppressSql;
        ReportFormat format;
        CommandScope commandScope = resultsBuilder.getCommandScope();
        Boolean enabled = (Boolean)commandScope.getArgumentValue(REPORT_ENABLED);
        String name = (String)commandScope.getArgumentValue(REPORT_NAME);
        String defaultName = ReportCommandArguments.getDefaultReportName(resultsBuilder.getCommandScope().getCommand().getName());
        String path = (String)commandScope.getArgumentValue(REPORT_PATH);
        ReportArguments arguments = this.handleArgumentHierarchy(enabled, name, path, format = (ReportFormat)((Object)commandScope.getArgumentValue(REPORT_FORMAT)), suppressSql = (Boolean)commandScope.getArgumentValue(SUPPRESS_SQL), suppressException = (Boolean)commandScope.getArgumentValue(SUPPRESS_EXCEPTION));
        if (arguments.getName().equals(REPORT_NAME_EXAMPLE)) {
            arguments.setName(defaultName);
        }
        commandScope.provideDependency(ReportCommandArguments.class, (Object)arguments);
    }

    private ReportArguments handleArgumentHierarchy(Boolean cmdEnabled, String cmdName, String cmdPath, ReportFormat cmdFormat, Boolean cmdSuppressSql, Boolean cmdSuppressException) {
        Boolean suppressSql;
        Boolean enabledSetting = (Boolean)this.getValue(cmdEnabled, ReportConfiguration.ENABLED.getCurrentValue());
        Boolean suppressExceptionSetting = suppressSql = (Boolean)this.getValue(cmdSuppressSql, ReportConfiguration.SUPPRESS_SQL.getCurrentValue());
        if (cmdSuppressException != null) {
            suppressExceptionSetting = cmdSuppressException;
        } else if (ReportConfiguration.SUPPRESS_EXCEPTION.getCurrentConfiguredValue().found() && !ReportConfiguration.SUPPRESS_EXCEPTION.getCurrentConfiguredValue().wasDefaultValueUsed()) {
            suppressExceptionSetting = (Boolean)ReportConfiguration.SUPPRESS_EXCEPTION.getCurrentValue();
        }
        ExceptionUtil.doSilently(() -> Scope.getCurrentScope().getAnalyticsEvent().setReportsEnabled(enabledSetting.booleanValue()));
        return new ReportArguments(enabledSetting, (String)this.getValue(cmdName, ReportConfiguration.NAME.getCurrentValue()), (String)this.getValue(cmdPath, ReportConfiguration.PATH.getCurrentValue()), (ReportFormat)((Object)this.getValue((Object)((Object)cmdFormat), (Object)ReportConfiguration.FORMAT.getCurrentValue())), !this.isOverride(cmdName), !this.isOverride(cmdPath), !this.isOverride(cmdFormat), suppressSql, suppressExceptionSetting);
    }

    private <T> T getValue(T commandValue, T globalValue) {
        return this.isOverride(commandValue) ? commandValue : globalValue;
    }

    private <T> boolean isOverride(T commandValue) {
        return commandValue != null;
    }

    public static String getDefaultReportName(String[] commandName) {
        String command = Arrays.stream(commandName).filter(Objects::nonNull).map(camelCaseName -> String.join((CharSequence)"-", StringUtils.splitByCharacterTypeCamelCase((String)camelCaseName))).map(String::toLowerCase).collect(Collectors.joining("-"));
        return String.format("%s-report-%s", StringUtils.capitalize((String)command), DEFAULT_REPORT_NAME_DATE_FORMAT);
    }

    static {
        REPORT_NAME_EXAMPLE = String.format("report-%s", DEFAULT_REPORT_NAME_DATE_FORMAT);
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        REPORT_ENABLED = builder.argument("reportEnabled", Boolean.class).description(ProStringUtil.markWithPro("Enable or disable reporting.")).addAlias("reportsEnabled").build();
        REPORT_NAME = builder.argument("reportName", String.class).description(ProStringUtil.markWithPro("The name of the report.")).addAlias("reportsName").build();
        REPORT_PATH = builder.argument("reportPath", String.class).description(ProStringUtil.markWithPro("The path to the directory to generate the report.")).addAlias("reportsPath").build();
        REPORT_FORMAT = builder.argument("reportFormat", ReportFormat.class).description(ProStringUtil.markWithPro("The format of the report. Currently, can only be set to \"html\".")).addAlias("reportsFormat").hidden().build();
        SUPPRESS_SQL = builder.argument("reportSuppressSql", Boolean.class).description(ProStringUtil.markWithPro("Setting to prevent the display of changeset SQL in operation reports.")).addAlias("reportsSuppressSql").build();
        SUPPRESS_EXCEPTION = builder.argument("reportSuppressException", Boolean.class).description(ProStringUtil.markWithPro("Setting to prevent the display of exceptions (which might contain SQL) in operation reports. If suppressSql is on, and no value is provided here, it is assumed to also be on.")).addAlias("reportsSuppressException").addAlias("reportSuppressExceptions").addAlias("reportsSuppressExceptions").build();
    }
}

