/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.type;

import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.statement.compositetype.ChangeCompositeTypeSchemaStatement;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.license.pro.LicenseTier;
import liquibase.statement.SqlStatement;
import lombok.Generated;

@DatabaseChange(name="changeCompositeTypeSchema", description="alter Composite Type to change its schema", priority=5)
public class ChangeCompositeTypeSchemaChange
extends AbstractChange {
    private String catalogName;
    private String typeName;
    private String oldSchemaName;
    private String newSchemaName;

    public boolean supports(Database database) {
        return database instanceof PostgresDatabase;
    }

    public ValidationErrors validate(Database database) {
        ValidationErrors errors = LicenseValidationChange.checkForValidLicense(LicenseTier.PRO, (Change)this);
        if (errors.hasErrors()) {
            return errors;
        }
        return super.validate(database);
    }

    public String getConfirmationMessage() {
        return "Schema for Composite Type '" + this.typeName + "' changed from '" + this.oldSchemaName + "' to '" + this.newSchemaName + "'.";
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new ChangeCompositeTypeSchemaStatement(this.catalogName, this.typeName, this.oldSchemaName, this.newSchemaName)};
    }

    protected Change[] createInverses() {
        ChangeCompositeTypeSchemaChange inverse = new ChangeCompositeTypeSchemaChange();
        inverse.setCatalogName(this.getCatalogName());
        inverse.setTypeName(this.getTypeName());
        inverse.setOldSchemaName(this.getNewSchemaName());
        inverse.setNewSchemaName(this.getOldSchemaName());
        return new Change[]{inverse};
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }

    @Generated
    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    public void setOldSchemaName(String oldSchemaName) {
        this.oldSchemaName = oldSchemaName;
    }

    @Generated
    public void setNewSchemaName(String newSchemaName) {
        this.newSchemaName = newSchemaName;
    }

    @Generated
    public String getCatalogName() {
        return this.catalogName;
    }

    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public String getOldSchemaName() {
        return this.oldSchemaName;
    }

    @Generated
    public String getNewSchemaName() {
        return this.newSchemaName;
    }
}

