/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.type;

import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.statement.compositetype.ChangeCompositeTypeOwnerStatement;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.license.pro.LicenseTier;
import liquibase.statement.SqlStatement;
import lombok.Generated;

@DatabaseChange(name="changeCompositeTypeOwner", description="alter Composite Type to change its owner", priority=5)
public class ChangeCompositeTypeOwnerChange
extends AbstractChange {
    private String catalogName;
    private String schemaName;
    private String typeName;
    private String newOwner;

    public boolean supports(Database database) {
        return database instanceof PostgresDatabase;
    }

    public ValidationErrors validate(Database database) {
        ValidationErrors errors = LicenseValidationChange.checkForValidLicense(LicenseTier.PRO, (Change)this);
        if (errors.hasErrors()) {
            return errors;
        }
        return super.validate(database);
    }

    public String getConfirmationMessage() {
        return "Owner for Composite Type '" + this.typeName + "' changed.";
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new ChangeCompositeTypeOwnerStatement(this.catalogName, this.schemaName, this.typeName, this.newOwner)};
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }

    @Generated
    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    public void setNewOwner(String newOwner) {
        this.newOwner = newOwner;
    }

    @Generated
    public String getCatalogName() {
        return this.catalogName;
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public String getNewOwner() {
        return this.newOwner;
    }
}

