/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.sqlite.crypt;

public enum SQLiteCryptParam {
    kdf_iter(256000, 1, null, "Number of iterations for key derivation"),
    fast_kdf_iter(2, 1, null, "Number of iterations for HMAC key derivation"),
    hmac_use(1, 0, 1, "Flag whether a HMAC should be used"),
    hmac_pgno(1, 0, 2, "Storage type for page number in HMAC: 0 = native, 1 = little endian, 2 = big endian"),
    hmac_salt_mask(58, 0, 255, "Mask byte for HMAC salt"),
    legacy(0, 0, 4, "SQLCipher version to be used in legacy mode"),
    legacy_page_size(4096, 0, 65536, "Page size to use in legacy mode, 0 = default SQLite page size"),
    kdf_algorithm(2, 0, 2, "Hash algoritm for key derivation function: 0 = SHA1, 1 = SHA256, 2 = SHA512"),
    hmac_algorithm(2, 0, 2, "Hash algoritm for HMAC calculation: 0 = SHA1, 1 = SHA256, 2 = SHA512"),
    plaintext_header_size(0, 0, 100, "Size of plaintext database header must be multiple of 16, i.e. 32");

    private Object defaultValue;
    private Object minValue;
    private Object maxValue;
    private String description;

    private SQLiteCryptParam(Object defaultValue, Object minValue, Object maxValue, String description) {
        this.defaultValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.description = description;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Object getMinValue() {
        return this.minValue;
    }

    public Object getMaxValue() {
        return this.maxValue;
    }

    public String getDescription() {
        return this.description;
    }
}

