/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cosmos.nosql.model;

import com.azure.cosmos.models.FeedResponse;
import com.dbeaver.db.cosmos.nosql.DCosmosSession;
import com.dbeaver.db.cosmos.nosql.ObjToMap;
import com.dbeaver.db.cosmos.nosql.exec.DCosmosBaseStatement;
import com.dbeaver.db.cosmos.nosql.model.DCosmosItem;
import com.dbeaver.model.document.exec.DocumentResultSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetSampleProvider;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Flux;

public class DCosmosResultIterable
extends DocumentResultSet<DCosmosSession, DCosmosBaseStatement>
implements DBRBlockingObject,
DBCResultSetSampleProvider {
    private static final Log log = Log.getLog(DCosmosResultIterable.class);
    private final PageCollector pageCollector = new PageCollector();
    private final long offset;
    private final long limit;
    @Nullable
    private List<Object> lastItems;
    private long returnedItems;
    private long processedItems;

    public DCosmosResultIterable(@NotNull DCosmosBaseStatement statement) {
        super((DBCStatement)statement);
        this.offset = statement.getOffset();
        this.limit = statement.getLimit();
    }

    public synchronized void subscribe(@NotNull Flux<FeedResponse<Object>> pages) {
        if (this.pageCollector.isSubscribed()) {
            throw new IllegalStateException("Already subscribed");
        }
        ((DCosmosSession)((DCosmosBaseStatement)this.statement).getSession()).getProgressMonitor().startBlock((DBRBlockingObject)this, "Fetch result");
        pages.subscribe((CoreSubscriber)this.pageCollector);
    }

    @Nullable
    public Object getAttributeValue(int index) throws DBCException {
        this.checkRowFetched();
        Object valueMap = this.lastItems.get(this.itemNumber);
        if (index == 0) {
            return this.createDocument(valueMap);
        }
        throw new DBCException("Index out of range (" + index + ")");
    }

    @Nullable
    public Object getAttributeValue(String name) throws DBCException {
        this.checkRowFetched();
        return this.createDocument(this.lastItems.get(this.itemNumber));
    }

    public boolean nextRow() throws DBCException {
        if (this.limit > 0L && this.returnedItems >= this.limit) {
            return false;
        }
        if (this.lastItems != null && this.lastItems.size() - 1 > this.itemNumber) {
            ++this.itemNumber;
            ++this.processedItems;
            if (this.processedItems <= this.offset) {
                return this.nextRow();
            }
            ++this.returnedItems;
            return true;
        }
        if (!this.fetchNextPage()) {
            return false;
        }
        return this.nextRow();
    }

    public void close() {
        ((DCosmosSession)((DCosmosBaseStatement)this.statement).getSession()).getProgressMonitor().endBlock();
        if (((DCosmosSession)((DCosmosBaseStatement)this.statement).getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleResultSetClose((DBCResultSet)this, (long)this.itemNumber);
        }
        this.pageCollector.cancel();
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        this.pageCollector.cancel();
    }

    /*
     * Loose catch block
     */
    private boolean fetchNextPage() throws DBCException {
        Result poll;
        if (this.pageCollector.isDisposed()) {
            return false;
        }
        Result result = poll = this.pageCollector.next();
        Objects.requireNonNull(result);
        Result result2 = result;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PageResult.class, ErrorResult.class, Completed.class, Canceled.class}, (Object)result2, 0)) {
            case 0: {
                FeedResponse<Object> response = ((PageResult)result2).response();
                this.lastItems = response.getResults();
                this.itemNumber = -1;
                return true;
            }
            case 1: {
                Throwable error = ((ErrorResult)result2).error();
                throw new DBCException("Error fetching next page", error);
            }
            case 2: {
                Completed ignored = (Completed)result2;
                return false;
            }
            case 3: {
                Canceled ignored = (Canceled)result2;
                return false;
            }
        }
        throw new MatchException(null, null);
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    @NotNull
    private Object createDocument(Object value) {
        return new DCosmosItem(((DCosmosSession)this.getSession()).getDataSource(), ((DCosmosBaseStatement)this.statement).getSourceEntity(), ObjToMap.toMap(value));
    }

    private record Canceled() implements Result
    {
    }

    private record Completed() implements Result
    {
    }

    private record ErrorResult(Throwable error) implements Result
    {
    }

    private static final class PageCollector
    extends BaseSubscriber<FeedResponse<Object>> {
        private final BlockingQueue<Result> pages = new LinkedBlockingQueue<Result>();

        private PageCollector() {
        }

        public Result next() throws DBCException {
            try {
                return this.pages.take();
            }
            catch (InterruptedException e) {
                throw new DBCException("Interrupted while waiting for next page", (Throwable)e);
            }
        }

        public boolean isSubscribed() {
            return this.upstream() != null;
        }

        protected void hookOnNext(@NotNull FeedResponse<Object> value) {
            this.putResult(new PageResult(value));
        }

        protected void hookOnComplete() {
            this.putResult(new Completed());
        }

        protected void hookOnError(@NotNull Throwable throwable) {
            this.putResult(new ErrorResult(throwable));
        }

        protected void hookOnCancel() {
            this.putResult(new Canceled());
        }

        private void putResult(Result result) {
            try {
                this.pages.put(result);
            }
            catch (InterruptedException e) {
                log.warn((Object)"Interrupted while putting result signal", (Throwable)e);
            }
        }
    }

    private record PageResult(FeedResponse<Object> response) implements Result
    {
    }

    private static sealed interface Result
    permits Canceled, Completed, ErrorResult, PageResult {
    }
}

