/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cosmos.nosql;

import com.dbeaver.db.cosmos.nosql.DCosmosContainer;
import com.dbeaver.db.cosmos.nosql.DCosmosNoSQLDataSource;
import com.dbeaver.db.cosmos.nosql.ObjToMap;
import com.dbeaver.db.cosmos.nosql.model.DCosmosItem;
import com.dbeaver.model.document.data.DBDocumentAttribute;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValue;
import org.jkiss.dbeaver.model.data.DBDValueHandlerComposite;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class DCosmosDocumentValueHandler
implements DBDValueHandlerComposite {
    public static final DCosmosDocumentValueHandler INSTANCE = new DCosmosDocumentValueHandler();

    @NotNull
    public Class<Object> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return Object.class;
    }

    @NotNull
    public String getValueContentType(@NotNull DBSTypedObject attribute) {
        return "text/json";
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof Map || value instanceof DBDValue) {
            return value.toString();
        }
        return DBValueFormatting.getDefaultValueDisplayString((Object)value, (DBDDisplayFormat)format);
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object instanceof DCosmosItem) {
            DCosmosItem item = (DCosmosItem)((Object)object);
            return copy ? item.copy() : item;
        }
        return new DCosmosItem((DCosmosNoSQLDataSource)session.getDataSource(), this.getContainer(type), ObjToMap.toMap(object));
    }

    public Object createNewValueObject(@NotNull DBCSession session, @NotNull DBSTypedObject type) throws DBCException {
        return new DCosmosItem((DCosmosNoSQLDataSource)session.getDataSource(), this.getContainer(type), Map.of());
    }

    public void releaseValueObject(Object value) {
    }

    @NotNull
    public DBCLogicalOperator[] getSupportedOperators(@NotNull DBSTypedObject attribute) {
        if (attribute.getDataKind() == DBPDataKind.DOCUMENT) {
            return new DBCLogicalOperator[0];
        }
        return new DBCLogicalOperator[]{DBCLogicalOperator.EQUALS, DBCLogicalOperator.NOT_EQUALS, DBCLogicalOperator.GREATER, DBCLogicalOperator.GREATER_EQUALS, DBCLogicalOperator.LESS, DBCLogicalOperator.LESS_EQUALS, DBCLogicalOperator.IN};
    }

    public final Object fetchValueObject(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, @NotNull DBSTypedObject type, int index) throws DBCException {
        Object attributeValue = resultSet.getAttributeValue(0);
        return this.getValueFromObject(session, type, attributeValue, false, false);
    }

    public void bindValueObject(@NotNull DBCSession session, @NotNull DBCStatement statement, @NotNull DBSTypedObject type, int index, Object value) throws DBCException {
        throw new DBCFeatureNotSupportedException("Document binding not supported");
    }

    @NotNull
    private DCosmosContainer getContainer(@NotNull DBSTypedObject type) throws DBCException {
        DBDocumentAttribute documentAttribute;
        DBSEntity dBSEntity;
        DBSTypedObject entityAttribute;
        Object object = entityAttribute = type instanceof DBDAttributeBinding ? ((DBDAttributeBinding)type).getEntityAttribute() : type;
        if (entityAttribute instanceof DBDocumentAttribute && (dBSEntity = (documentAttribute = (DBDocumentAttribute)entityAttribute).getParentObject()) instanceof DCosmosContainer) {
            DCosmosContainer cosmosContainer = (DCosmosContainer)dBSEntity;
            return cosmosContainer;
        }
        throw new DBCException("Invalid attribute type: " + String.valueOf(entityAttribute));
    }
}

