/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.sqlgenerator;

import liquibase.database.Database;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.RenameViewGenerator;
import liquibase.statement.core.RenameViewStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.View;

public class RenameViewGeneratorDatabricks
extends RenameViewGenerator {
    public boolean supports(RenameViewStatement statement, Database database) {
        return database instanceof DatabricksDatabase;
    }

    public int getPriority() {
        return 5;
    }

    public Sql[] generateSql(RenameViewStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String sql = "ALTER VIEW " + database.escapeViewName(statement.getCatalogName(), statement.getSchemaName(), statement.getOldViewName()) + " RENAME TO " + database.escapeObjectName(statement.getNewViewName(), View.class);
        return new Sql[]{new UnparsedSql(sql, new DatabaseObject[]{this.getAffectedOldView(statement), this.getAffectedNewView(statement)})};
    }
}

