/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.sqlgenerator;

import liquibase.database.Database;
import liquibase.database.core.MySQLDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.RenameColumnGenerator;
import liquibase.statement.core.RenameColumnStatement;
import liquibase.structure.DatabaseObject;
import org.apache.commons.lang3.StringUtils;

public class RenameColumnGeneratorDatabricks
extends RenameColumnGenerator {
    public boolean supports(RenameColumnStatement statement, Database database) {
        return database instanceof DatabricksDatabase;
    }

    public int getPriority() {
        return 5;
    }

    public ValidationErrors validate(RenameColumnStatement renameColumnStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("tableName", (Object)renameColumnStatement.getTableName());
        validationErrors.checkRequiredField("oldColumnName", (Object)renameColumnStatement.getOldColumnName());
        validationErrors.checkRequiredField("newColumnName", (Object)renameColumnStatement.getNewColumnName());
        if (database instanceof MySQLDatabase) {
            validationErrors.checkRequiredField("columnDataType", (Object)StringUtils.trimToNull((String)renameColumnStatement.getColumnDataType()));
        }
        return validationErrors;
    }

    public Sql[] generateSql(RenameColumnStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String sql = "ALTER TABLE " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()) + " RENAME COLUMN " + database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getOldColumnName()) + " TO " + database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getNewColumnName());
        return new Sql[]{new UnparsedSql(sql, new DatabaseObject[]{this.getAffectedOldColumn(statement), this.getAffectedNewColumn(statement)})};
    }
}

