/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.sqlgenerator;

import java.util.Arrays;
import java.util.Iterator;
import liquibase.change.AddColumnConfig;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.CreateIndexGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.CreateIndexStatement;
import liquibase.structure.DatabaseObject;

public class CreateIndexGeneratorDatabricks
extends CreateIndexGenerator {
    public boolean supports(CreateIndexStatement statement, Database database) {
        return super.supports((SqlStatement)statement, database) && database instanceof DatabricksDatabase;
    }

    public int getPriority() {
        return 5;
    }

    public ValidationErrors validate(CreateIndexStatement createIndexStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("tableName", (Object)createIndexStatement.getTableName());
        validationErrors.checkRequiredField("columns", (Object)createIndexStatement.getColumns());
        return validationErrors;
    }

    public Sql[] generateSql(CreateIndexStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("ALTER TABLE ");
        buffer.append(database.escapeTableName(statement.getTableCatalogName(), statement.getTableSchemaName(), statement.getTableName())).append(" CLUSTER BY ");
        Iterator<AddColumnConfig> iterator = Arrays.asList(statement.getColumns()).iterator();
        if (!iterator.hasNext()) {
            buffer.append(" NONE ");
        } else {
            buffer.append("(");
            while (iterator.hasNext()) {
                AddColumnConfig column = iterator.next();
                buffer.append(column.getName());
                if (!iterator.hasNext()) continue;
                buffer.append(", ");
            }
        }
        buffer.append(")");
        return new Sql[]{new UnparsedSql(buffer.toString(), new DatabaseObject[]{this.getAffectedIndex(statement)})};
    }
}

