/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.sqlgenerator;

import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.ext.databricks.change.alterTableProperties.AlterTablePropertiesStatementDatabricks;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;

public class AlterTablePropertiesGeneratorDatabricks
extends AbstractSqlGenerator<AlterTablePropertiesStatementDatabricks> {
    public boolean supports(AlterTablePropertiesStatementDatabricks statement, Database database) {
        return super.supports((SqlStatement)statement, database) && database instanceof DatabricksDatabase;
    }

    public int getPriority() {
        return 5;
    }

    public ValidationErrors validate(AlterTablePropertiesStatementDatabricks statement, Database database, SqlGeneratorChain<AlterTablePropertiesStatementDatabricks> sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        if (statement.getSetExtendedTableProperties() == null && statement.getUnsetExtendedTableProperties() == null) {
            validationErrors.addError("WARNING! Alter Table Properties change require 'setExtendedTableProperties' or 'unsetExtendedTableProperties' element, please add at least one option.");
        }
        return validationErrors;
    }

    public Sql[] generateSql(AlterTablePropertiesStatementDatabricks statement, Database database, SqlGeneratorChain<AlterTablePropertiesStatementDatabricks> sqlGeneratorChain) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("ALTER TABLE ");
        buffer.append(database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()));
        if (statement.getSetExtendedTableProperties() != null) {
            buffer.append(" SET TBLPROPERTIES (");
            buffer.append(statement.getSetExtendedTableProperties().getTblProperties());
        } else if (statement.getUnsetExtendedTableProperties() != null) {
            buffer.append(" UNSET TBLPROPERTIES (");
            buffer.append(statement.getUnsetExtendedTableProperties().getTblProperties());
        }
        buffer.append(")");
        return new Sql[]{new UnparsedSql(buffer.toString(), new DatabaseObject[0])};
    }
}

