/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.snapshot.jvm;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.jvm.TableSnapshotGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawParameterizedSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Table;

public class TableSnapshotGeneratorDatabricks
extends TableSnapshotGenerator {
    private static final String LOCATION = "Location";
    private static final String PROVIDER = "Provider";
    private static final String STORAGE_PROPERTIES = "Storage Properties";
    private static final String TABLE_FORMAT = "tableFormat";
    private static final String TBL_PROPERTIES = "tblProperties";
    private static final String CLUSTER_COLUMNS = "clusteringColumns";
    private static final String PARTITION_COLUMNS = "partitionColumns";
    private static final String DETAILED_TABLE_INFORMATION_NODE = "# Detailed Table Information";
    private static final String TABLE_PARTITION_INFORMATION_NODE = "# Partition Information";
    private static final String DATA_TYPE = "DATA_TYPE";
    private static final List<String> FILE_TYPE_PROVIDERS = Arrays.asList("AVRO", "BINARYFILE", "CSV", "JSON", "ORC", "PARQUET", "TEXT");

    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (database instanceof DatabricksDatabase) {
            return 5;
        }
        return -1;
    }

    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException {
        Table table = (Table)super.snapshotObject(example, snapshot);
        Database database = snapshot.getDatabase();
        if (table != null) {
            String showCreateTableQuery;
            String query = String.format("DESCRIBE TABLE EXTENDED %s.%s.%s;", database.getDefaultCatalogName(), database.getDefaultSchemaName(), example.getName());
            Executor jdbcExecutor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
            List tablePropertiesResponse = jdbcExecutor.queryForList((SqlStatement)new RawParameterizedSqlStatement(query));
            List<String> changelogTableNames = Arrays.asList(database.getDatabaseChangeLogLockTableName(), database.getDatabaseChangeLogTableName());
            if (!changelogTableNames.contains(table.getName()) && snapshot.getScratchData(showCreateTableQuery = String.format("SHOW CREATE TABLE %s.%s.%s;", table.getSchema().getCatalog(), table.getSchema().getName(), table.getName())) == null) {
                String createTableStatement = (String)jdbcExecutor.queryForObject((SqlStatement)new RawParameterizedSqlStatement(showCreateTableQuery), String.class);
                snapshot.setScratchData(showCreateTableQuery, (Object)createTableStatement);
            }
            StringBuilder tableFormat = new StringBuilder();
            boolean detailedInformationNode = false;
            boolean partitionInformationNode = false;
            StringBuilder partitionColumns = new StringBuilder();
            for (Map tableProperty : tablePropertiesResponse) {
                String currentColName = (String)tableProperty.get("COL_NAME");
                if (currentColName.equals(DETAILED_TABLE_INFORMATION_NODE)) {
                    detailedInformationNode = true;
                    continue;
                }
                if (detailedInformationNode) {
                    if (currentColName.equals(LOCATION)) {
                        table.setAttribute(LOCATION, tableProperty.get(DATA_TYPE));
                    }
                    if (currentColName.equals(PROVIDER) && FILE_TYPE_PROVIDERS.contains(tableProperty.get(DATA_TYPE).toString().toUpperCase())) {
                        tableFormat.append(tableProperty.get(DATA_TYPE));
                    }
                    if (!tableFormat.toString().isEmpty() && currentColName.equals(STORAGE_PROPERTIES)) {
                        if (table.getAttribute(LOCATION, String.class) != null) {
                            tableFormat.append(" ").append(LOCATION.toUpperCase()).append("'").append((String)table.getAttribute(LOCATION, String.class)).append("' ");
                        }
                        tableFormat.append(this.extractOptionsFromStorageProperties(tableProperty.get(DATA_TYPE)));
                        table.setAttribute(TABLE_FORMAT, (Object)tableFormat.toString());
                    }
                }
                if (currentColName.equals(TABLE_PARTITION_INFORMATION_NODE)) {
                    partitionInformationNode = true;
                    continue;
                }
                if (!partitionInformationNode || currentColName.equals("# col_name")) continue;
                if (currentColName.equals("")) {
                    partitionInformationNode = false;
                    continue;
                }
                if (partitionColumns.toString().isEmpty()) {
                    partitionColumns.append(currentColName);
                    continue;
                }
                partitionColumns.append(',').append(currentColName);
            }
            Map<String, String> tblProperties = this.getTblPropertiesMap(database, example.getName());
            if (tblProperties.containsKey(CLUSTER_COLUMNS)) {
                table.setAttribute(CLUSTER_COLUMNS, (Object)this.sanitizeClusterColumns(tblProperties.remove(CLUSTER_COLUMNS)));
            }
            if (!partitionColumns.toString().isEmpty()) {
                table.setAttribute(PARTITION_COLUMNS, (Object)partitionColumns.toString());
            }
            table.setAttribute(TBL_PROPERTIES, (Object)this.getTblPropertiesString(tblProperties));
        }
        return table;
    }

    private String extractOptionsFromStorageProperties(Object storageProperties) {
        Matcher matcher;
        StringBuilder options = new StringBuilder();
        if (storageProperties instanceof String && (matcher = Pattern.compile("(\\b\\w+\\b)=(.*?)(,|\\])").matcher((String)storageProperties)).find()) {
            options.append(" OPTIONS (").append(matcher.group(1)).append(" '").append(matcher.group(2)).append("'");
            while (matcher.find()) {
                options.append(", ").append(matcher.group(1)).append(" '").append(matcher.group(2)).append("'");
            }
            options.append(")");
        }
        return options.toString();
    }

    private Map<String, String> getTblPropertiesMap(Database database, String table) throws DatabaseException {
        String query = String.format("SHOW TBLPROPERTIES %s.%s.%s;", database.getDefaultCatalogName(), database.getDefaultSchemaName(), table);
        List tablePropertiesResponse = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database).queryForList((SqlStatement)new RawParameterizedSqlStatement(query));
        return tablePropertiesResponse.stream().collect(Collectors.toMap(mapElement -> (String)mapElement.get("KEY"), mapElement -> (String)mapElement.get("VALUE")));
    }

    private String getTblPropertiesString(Map<String, String> propertiesMap) {
        StringBuilder csvString = new StringBuilder();
        propertiesMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> csvString.append("'").append((String)entry.getKey()).append("'='").append((String)entry.getValue()).append("', "));
        return csvString.toString().replaceAll(", $", "");
    }

    private String sanitizeClusterColumns(String clusterColumnProperty) {
        Pattern pattern = Pattern.compile("[\\[\\]\\\"]");
        return clusterColumnProperty.replaceAll(pattern.toString(), "");
    }
}

