/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.database;

import com.databricks.client.jdbc.jdbc42.S42Connection;
import com.databricks.client.spark.core.SparkJDBCConnection;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import liquibase.Scope;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;

public class DatabricksConnection
extends JdbcConnection {
    private S42Connection con;

    public DatabricksConnection() {
    }

    public DatabricksConnection(Connection conn) {
        this.con = (S42Connection)conn;
    }

    public String getDatabaseProductName() throws DatabaseException {
        try {
            return this.getWrappedConnection().getMetaData().getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public Connection getWrappedConnection() {
        return this.con;
    }

    public SparkJDBCConnection getUnderlyingSparkConnection() {
        if (this.con.getConnection() instanceof SparkJDBCConnection) {
            return (SparkJDBCConnection)this.con.getConnection();
        }
        return null;
    }

    public Connection getUnderlyingConnection() {
        return this.con;
    }

    public void open(String url, Driver driverObject, Properties driverProperties) throws DatabaseException {
        driverProperties.setProperty("UserAgentEntry", "Liquibase");
        driverProperties.setProperty("EnableArrow", "0");
        if (!url.endsWith(";")) {
            url = url + ";";
        }
        String updatedUrl = url + "UserAgentEntry=Liquibase;EnableArrow=0";
        this.openConn(updatedUrl, driverObject, driverProperties);
    }

    public void openConn(String url, Driver driverObject, Properties driverProperties) throws DatabaseException {
        try {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("opening connection " + url);
            this.con = (S42Connection)driverObject.connect(url, driverProperties);
            if (this.con == null) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).severe("Connection could not be created");
                throw new DatabaseException("Connection could not be created to " + url + " with driver " + driverObject.getClass().getName() + ".  Possibly the wrong driver for the given database URL");
            }
        }
        catch (SQLException sqle) {
            throw new DatabaseException("Connection could not be created to " + url + " with driver " + driverObject.getClass().getName() + ".  " + sqle.getMessage());
        }
    }

    public boolean supports(String url) {
        return url.toLowerCase().contains("databricks");
    }

    public int getPriority() {
        return 106;
    }

    public boolean getAutoCommit() throws DatabaseException {
        return true;
    }

    public void setAutoCommit(boolean autoCommit) throws DatabaseException {
    }

    protected static String getUrlParamValue(String url, String paramName, String defaultValue) {
        String[] uriArgs;
        Optional<String> paramString;
        if (url == null) {
            return null;
        }
        if (!url.endsWith(";")) {
            url = url + ";";
        }
        if (!(paramString = Arrays.stream(uriArgs = url.replace(" ", "").split(";")).filter(x -> x.startsWith(paramName + "=")).findFirst()).isPresent()) {
            return defaultValue;
        }
        String[] defaultParamsArr = paramString.get().split("=");
        return defaultParamsArr.length > 1 ? defaultParamsArr[1] : defaultValue;
    }

    public String getDatabaseProductVersion() throws DatabaseException {
        try {
            return this.con.getMetaData().getDatabaseProductVersion();
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public int getDatabaseMajorVersion() throws DatabaseException {
        try {
            return this.con.getMetaData().getDatabaseMajorVersion();
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public int getDatabaseMinorVersion() throws DatabaseException {
        try {
            return this.con.getMetaData().getDatabaseMinorVersion();
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    protected String getConnectionUrl() throws SQLException {
        String rawUrl = this.con.getMetaData().getURL();
        String updatedUrl = rawUrl.charAt(rawUrl.length() - 1) == ';' ? rawUrl + "UserAgentEntry=Liquibase;EnableArrow=0;" : rawUrl + ";UserAgentEntry=Liquibase;EnableArrow=0;";
        return updatedUrl;
    }

    public String getConnectionUserName() {
        try {
            return this.con.getMetaData().getUserName();
        }
        catch (SQLException e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
    }

    public void clearWarnings() throws DatabaseException {
        try {
            this.con.clearWarnings();
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public void close() throws DatabaseException {
        this.rollback();
        try {
            this.con.close();
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public void commit() throws DatabaseException {
        try {
            if (!this.con.getAutoCommit()) {
                this.con.commit();
            }
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public Statement createStatement() throws DatabaseException {
        try {
            return this.con.createStatement();
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws DatabaseException {
        try {
            return this.con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws DatabaseException {
        try {
            return this.con.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public String getCatalog() throws DatabaseException {
        try {
            return this.con.getCatalog();
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public void setCatalog(String catalog) throws DatabaseException {
        try {
            this.con.setCatalog(catalog);
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public int getHoldability() throws DatabaseException {
        try {
            return this.con.getHoldability();
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public void setHoldability(int holdability) throws DatabaseException {
        try {
            this.con.setHoldability(holdability);
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public DatabaseMetaData getMetaData() throws DatabaseException {
        try {
            return this.con.getMetaData();
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public int getTransactionIsolation() throws DatabaseException {
        try {
            return this.con.getTransactionIsolation();
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public void setTransactionIsolation(int level) throws DatabaseException {
        try {
            this.con.setTransactionIsolation(level);
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public Map<String, Class<?>> getTypeMap() throws DatabaseException {
        try {
            return this.con.getTypeMap();
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public void setTypeMap(Map<String, Class<?>> map) throws DatabaseException {
        try {
            this.con.setTypeMap(map);
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public SQLWarning getWarnings() throws DatabaseException {
        try {
            return this.con.getWarnings();
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public boolean isClosed() throws DatabaseException {
        return this.con.isClosed();
    }

    public boolean isReadOnly() throws DatabaseException {
        try {
            return this.con.isReadOnly();
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public void setReadOnly(boolean readOnly) throws DatabaseException {
        try {
            this.con.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public String nativeSQL(String sql) throws DatabaseException {
        try {
            return this.con.nativeSQL(sql);
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws DatabaseException {
        try {
            return this.con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws DatabaseException {
        try {
            return this.con.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public CallableStatement prepareCall(String sql) throws DatabaseException {
        try {
            return this.con.prepareCall(sql);
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws DatabaseException {
        try {
            return this.con.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws DatabaseException {
        try {
            return this.con.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws DatabaseException {
        try {
            return this.con.prepareStatement(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws DatabaseException {
        try {
            return this.con.prepareStatement(sql, columnIndexes);
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws DatabaseException {
        try {
            return this.con.prepareStatement(sql, columnNames);
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public PreparedStatement prepareStatement(String sql) throws DatabaseException {
        try {
            return this.con.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws DatabaseException {
        try {
            this.con.releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public void rollback() throws DatabaseException {
        try {
            if (!this.con.getAutoCommit() && !this.con.isClosed()) {
                this.con.rollback();
            }
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public void rollback(Savepoint savepoint) throws DatabaseException {
        try {
            if (!this.con.getAutoCommit()) {
                this.con.rollback(savepoint);
            }
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public Savepoint setSavepoint() throws DatabaseException {
        try {
            return this.con.setSavepoint();
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public Savepoint setSavepoint(String name) throws DatabaseException {
        try {
            return this.con.setSavepoint(name);
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JdbcConnection)) {
            return false;
        }
        Connection underlyingConnection = this.getUnderlyingConnection();
        if (underlyingConnection == null) {
            return ((JdbcConnection)obj).getUnderlyingConnection() == null;
        }
        return underlyingConnection.equals(((JdbcConnection)obj).getUnderlyingConnection());
    }

    public int hashCode() {
        Connection underlyingConnection = this.getUnderlyingConnection();
        try {
            if (underlyingConnection == null || underlyingConnection.isClosed()) {
                return super.hashCode();
            }
        }
        catch (SQLException e) {
            return super.hashCode();
        }
        return underlyingConnection.hashCode();
    }
}

