/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.change.dropCheckConstraint;

import java.text.MessageFormat;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.ext.databricks.change.dropCheckConstraint.DropCheckConstraintStatementDatabricks;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.statement.SqlStatement;
import lombok.Generated;

@DatabaseChange(name="dropCheckConstraint", description="Drops check constraint to Delta Table", priority=5)
public class DropCheckConstraintChangeDatabricks
extends AbstractChange {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String constraintName;

    public boolean supports(Database database) {
        return database instanceof DatabricksDatabase;
    }

    @DatabaseChangeProperty(description="Name of the check constraint")
    public String getConstraintName() {
        return this.constraintName;
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("{0}.{1}.{2} successfully Dropped check constraint {3}.", this.getCatalogName(), this.getSchemaName(), this.getTableName(), this.getConstraintName());
    }

    protected Change[] createInverses() {
        return new Change[0];
    }

    public SqlStatement[] generateStatements(Database database) {
        DropCheckConstraintStatementDatabricks statement = new DropCheckConstraintStatementDatabricks();
        statement.setCatalogName(this.getCatalogName());
        statement.setSchemaName(this.getSchemaName());
        statement.setTableName(this.getTableName());
        statement.setConstraintName(this.getConstraintName());
        return new SqlStatement[]{statement};
    }

    @Generated
    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    @Generated
    public String getCatalogName() {
        return this.catalogName;
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }
}

