/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.change.createTable;

import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.CreateTableChange;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.ext.databricks.change.createTable.CreateTableStatementDatabricks;
import liquibase.ext.databricks.change.createTable.ExtendedTableProperties;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.statement.core.CreateTableStatement;
import lombok.Generated;

@DatabaseChange(name="createTable", description="Create Table", priority=5)
public class CreateTableChangeDatabricks
extends CreateTableChange {
    private static final String DOUBLE_INIT_ERROR = "Double initialization of extended table properties is not allowed. Please avoid using both EXT createTable attributes and Databricks specific extendedTableProperties element. Element databricks:extendedTableProperties is preferred way to set databricks specific configurations.";
    private static final String PARTITION_CLUSTER_COLLISION_ERROR = "Databricks does not support CLUSTER columns AND PARTITION BY columns, please pick one.";
    private String tableFormat;
    private String tableLocation;
    private String clusterColumns;
    private String partitionColumns;
    private ExtendedTableProperties extendedTableProperties;

    public boolean supports(Database database) {
        return database instanceof DatabricksDatabase;
    }

    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.addAll(super.validate(database));
        if (this.partitionColumns != null && this.clusterColumns != null) {
            validationErrors.addError(PARTITION_CLUSTER_COLLISION_ERROR);
        }
        if (this.extendedTableProperties != null) {
            boolean anyPropertyDuplicated;
            boolean bl = anyPropertyDuplicated = this.tableFormat != null && this.extendedTableProperties.getTableFormat() != null || this.tableLocation != null && this.extendedTableProperties.getTableLocation() != null || this.clusterColumns != null && this.extendedTableProperties.getClusterColumns() != null || this.partitionColumns != null && this.extendedTableProperties.getPartitionColumns() != null;
            if (anyPropertyDuplicated) {
                validationErrors.addError(DOUBLE_INIT_ERROR);
            }
        }
        return validationErrors;
    }

    @DatabaseChangeProperty
    public String getTableFormat() {
        return this.tableFormat;
    }

    @DatabaseChangeProperty
    public String getTableLocation() {
        return this.tableLocation;
    }

    @DatabaseChangeProperty
    public String getClusterColumns() {
        return this.clusterColumns;
    }

    @DatabaseChangeProperty
    public String getPartitionColumns() {
        return this.partitionColumns;
    }

    protected CreateTableStatement generateCreateTableStatement() {
        CreateTableStatementDatabricks ctas = new CreateTableStatementDatabricks(this.getCatalogName(), this.getSchemaName(), this.getTableName());
        if (this.getExtendedTableProperties() != null) {
            ctas.setTableLocation(this.getExtendedTableProperties().getTableLocation());
            ctas.setTableFormat(this.getExtendedTableProperties().getTableFormat());
            ctas.setClusterColumns(this.getExtendedTableProperties().getClusterColumns());
            ctas.setPartitionColumns(this.getExtendedTableProperties().getPartitionColumns());
            ctas.setExtendedTableProperties(this.getExtendedTableProperties());
        } else {
            ctas.setTableFormat(this.getTableFormat());
            ctas.setTableLocation(this.getTableLocation());
            ctas.setClusterColumns(this.getClusterColumns());
            ctas.setPartitionColumns(this.getPartitionColumns());
        }
        return ctas;
    }

    @DatabaseChangeProperty
    public ExtendedTableProperties getExtendedTableProperties() {
        return this.extendedTableProperties;
    }

    @Generated
    public void setTableFormat(String tableFormat) {
        this.tableFormat = tableFormat;
    }

    @Generated
    public void setTableLocation(String tableLocation) {
        this.tableLocation = tableLocation;
    }

    @Generated
    public void setClusterColumns(String clusterColumns) {
        this.clusterColumns = clusterColumns;
    }

    @Generated
    public void setPartitionColumns(String partitionColumns) {
        this.partitionColumns = partitionColumns;
    }

    @Generated
    public void setExtendedTableProperties(ExtendedTableProperties extendedTableProperties) {
        this.extendedTableProperties = extendedTableProperties;
    }
}

