/*
 * Decompiled with CFR 0.152.
 */
package com.informix.timeseries.field.definition;

import com.informix.jdbc.IfmxUDTSQLInput;
import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.lang.Decimal;
import com.informix.lang.JavaToIfxType;
import com.informix.timeseries.IfmxTimeSeries;
import com.informix.timeseries.field.definition.AbstractInformixFieldDefinition;
import com.informix.timeseries.field.definition.DecimalTimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.ObjectConversionUtilities;
import com.informix.timeseries.field.definition.TimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.TimeSeriesFieldDefinitionFactory;
import com.informix.timeseries.field.definition.TimeSeriesFieldType;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;

public class TimeTimeSeriesFieldDefinition
extends AbstractInformixFieldDefinition<Time>
implements TimeSeriesFieldDefinition<Time> {
    public TimeTimeSeriesFieldDefinition() {
        super(TimeSeriesFieldType.TIME);
    }

    public static TimeTimeSeriesFieldDefinition parseFieldDefinition(String s) {
        String trimmed = s.trim();
        if (trimmed.equalsIgnoreCase(TimeSeriesFieldType.TIME.getInformixTypeName())) {
            return new TimeTimeSeriesFieldDefinition();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Time read(IfmxUDTSQLInput stream, IfxResultSetMetaData metaData, Integer fieldIndex) throws SQLException {
        int precision = metaData.getEncodedLength(fieldIndex);
        Decimal decVal = DecimalTimeSeriesFieldDefinition.readDecimal(stream, precision, true);
        Calendar cal = Calendar.getInstance(IfmxTimeSeries.getDefaultTimeZone());
        Timestamp timestamp = decVal.timestampValue(cal);
        cal.set(1970, 0, 1, timestamp.getHours(), timestamp.getMinutes(), timestamp.getSeconds());
        Time time = new Time(cal.getTimeInMillis());
        return time;
    }

    @Override
    public void write(IfmxUDTSQLOutput stream, Time value) throws SQLException {
        if (!(value instanceof Time)) {
            throw new SQLException(MessageFormat.format("the value must be of type {0} (was {1})", Time.class.getName(), value.getClass().getName()));
        }
        Decimal decVal = JavaToIfxType.convertTimeToDecimal(value);
        DecimalTimeSeriesFieldDefinition.writeDecimal(stream, decVal);
    }

    @Override
    public String convertValueToString(Object value) {
        if (value == null) {
            return "null::" + this.toSqlString();
        }
        if (value instanceof Time) {
            StringBuilder sb = new StringBuilder();
            sb.append('\'');
            sb.append(((Time)value).toString());
            sb.append('\'');
            sb.append("::");
            sb.append(this.toSqlString());
            return sb.toString();
        }
        throw new IllegalArgumentException(MessageFormat.format("the value must be of type {0} (was {1})", Time.class, value.getClass()));
    }

    @Override
    public Time convertValueTo(Object value) throws IllegalArgumentException {
        if (value == null || value instanceof Time) {
            return (Time)value;
        }
        Long l = ObjectConversionUtilities.convertObjectToLong(value, Date.class.getName());
        return new Time(l);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TimeTimeSeriesFieldDefinition []");
        return builder.toString();
    }

    public static class Factory
    implements TimeSeriesFieldDefinitionFactory<Time> {
        @Override
        public TimeSeriesFieldDefinition<Time> parse(String s) {
            return TimeTimeSeriesFieldDefinition.parseFieldDefinition(s);
        }
    }
}

