/*
 * Decompiled with CFR 0.152.
 */
package com.informix.timeseries.field.definition;

import com.informix.timeseries.field.definition.BigIntTimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.BooleanTimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.BsonTimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.ByteTimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.CharTimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.DateTimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.DateTimeTimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.DecimalTimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.FloatTimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.Int8TimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.IntTimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.IntervalTimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.SmallFloatTimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.SmallIntTimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.TimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.TimeSeriesFieldDefinitionFactory;
import com.informix.timeseries.field.definition.TimeTimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.TimestampTimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.VarcharTimeSeriesFieldDefinition;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class TimeSeriesFieldDefinitionRegistry {
    private static final CopyOnWriteArraySet<TimeSeriesFieldDefinition<?>> fieldDefinitions = new CopyOnWriteArraySet();
    private static final CopyOnWriteArraySet<TimeSeriesFieldDefinitionFactory<?>> fieldDefinitionFactories;

    static {
        TimeSeriesFieldDefinitionRegistry.register(new BigIntTimeSeriesFieldDefinition());
        TimeSeriesFieldDefinitionRegistry.register(new BooleanTimeSeriesFieldDefinition());
        TimeSeriesFieldDefinitionRegistry.register(new BsonTimeSeriesFieldDefinition());
        TimeSeriesFieldDefinitionRegistry.register(new ByteTimeSeriesFieldDefinition());
        TimeSeriesFieldDefinitionRegistry.register(new CharTimeSeriesFieldDefinition());
        TimeSeriesFieldDefinitionRegistry.register(new DateTimeSeriesFieldDefinition());
        TimeSeriesFieldDefinitionRegistry.register(new DateTimeTimeSeriesFieldDefinition());
        TimeSeriesFieldDefinitionRegistry.register(new DecimalTimeSeriesFieldDefinition());
        TimeSeriesFieldDefinitionRegistry.register(new FloatTimeSeriesFieldDefinition());
        TimeSeriesFieldDefinitionRegistry.register(new Int8TimeSeriesFieldDefinition());
        TimeSeriesFieldDefinitionRegistry.register(new IntervalTimeSeriesFieldDefinition());
        TimeSeriesFieldDefinitionRegistry.register(new IntTimeSeriesFieldDefinition());
        TimeSeriesFieldDefinitionRegistry.register(new SmallFloatTimeSeriesFieldDefinition());
        TimeSeriesFieldDefinitionRegistry.register(new SmallIntTimeSeriesFieldDefinition());
        TimeSeriesFieldDefinitionRegistry.register(new TimeTimeSeriesFieldDefinition());
        TimeSeriesFieldDefinitionRegistry.register(new TimestampTimeSeriesFieldDefinition());
        TimeSeriesFieldDefinitionRegistry.register(new VarcharTimeSeriesFieldDefinition());
        fieldDefinitionFactories = new CopyOnWriteArraySet();
        TimeSeriesFieldDefinitionRegistry.register(new BigIntTimeSeriesFieldDefinition.Factory());
        TimeSeriesFieldDefinitionRegistry.register(new BooleanTimeSeriesFieldDefinition.Factory());
        TimeSeriesFieldDefinitionRegistry.register(new BsonTimeSeriesFieldDefinition.Factory());
        TimeSeriesFieldDefinitionRegistry.register(new ByteTimeSeriesFieldDefinition.Factory());
        TimeSeriesFieldDefinitionRegistry.register(new CharTimeSeriesFieldDefinition.Factory());
        TimeSeriesFieldDefinitionRegistry.register(new DateTimeSeriesFieldDefinition.Factory());
        TimeSeriesFieldDefinitionRegistry.register(new DateTimeTimeSeriesFieldDefinition.Factory());
        TimeSeriesFieldDefinitionRegistry.register(new DecimalTimeSeriesFieldDefinition.Factory());
        TimeSeriesFieldDefinitionRegistry.register(new FloatTimeSeriesFieldDefinition.Factory());
        TimeSeriesFieldDefinitionRegistry.register(new Int8TimeSeriesFieldDefinition.Factory());
        TimeSeriesFieldDefinitionRegistry.register(new IntervalTimeSeriesFieldDefinition.Factory());
        TimeSeriesFieldDefinitionRegistry.register(new IntTimeSeriesFieldDefinition.Factory());
        TimeSeriesFieldDefinitionRegistry.register(new SmallFloatTimeSeriesFieldDefinition.Factory());
        TimeSeriesFieldDefinitionRegistry.register(new SmallIntTimeSeriesFieldDefinition.Factory());
        TimeSeriesFieldDefinitionRegistry.register(new TimeTimeSeriesFieldDefinition.Factory());
        TimeSeriesFieldDefinitionRegistry.register(new TimestampTimeSeriesFieldDefinition.Factory());
        TimeSeriesFieldDefinitionRegistry.register(new VarcharTimeSeriesFieldDefinition.Factory());
    }

    private TimeSeriesFieldDefinitionRegistry() {
    }

    public static void register(TimeSeriesFieldDefinition<?> fieldDefinition) {
        fieldDefinitions.add(fieldDefinition);
    }

    public static Set<TimeSeriesFieldDefinition<?>> getFieldDefinitions() {
        return fieldDefinitions;
    }

    public static void register(TimeSeriesFieldDefinitionFactory<?> fieldDefinitionFactory) {
        fieldDefinitionFactories.add(fieldDefinitionFactory);
    }

    public static Set<TimeSeriesFieldDefinitionFactory<?>> getFieldDefinitionFactories() {
        return fieldDefinitionFactories;
    }

    public static TimeSeriesFieldDefinition<?> parseFieldDefinition(String s) {
        for (TimeSeriesFieldDefinitionFactory<?> factory : fieldDefinitionFactories) {
            try {
                TimeSeriesFieldDefinition<?> fieldDef = factory.parse(s);
                return fieldDef;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("no field definition in the registry is capable of parsing the string representation");
    }
}

