/*
 * Decompiled with CFR 0.152.
 */
package com.informix.timeseries.field.definition;

import com.informix.jdbc.IfmxUDTSQLInput;
import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.jdbc.IfxBSONObject;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.json.JSONSerializers;
import com.informix.timeseries.field.definition.AbstractInformixFieldDefinition;
import com.informix.timeseries.field.definition.TimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.TimeSeriesFieldDefinitionFactory;
import com.informix.timeseries.field.definition.TimeSeriesFieldType;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.text.MessageFormat;
import org.bson.BSONObject;
import org.bson.BasicBSONDecoder;
import org.bson.BasicBSONEncoder;

public class BsonTimeSeriesFieldDefinition
extends AbstractInformixFieldDefinition<IfxBSONObject>
implements TimeSeriesFieldDefinition<IfxBSONObject> {
    public BsonTimeSeriesFieldDefinition() {
        super(TimeSeriesFieldType.BSON);
    }

    @Override
    public IfxBSONObject read(IfmxUDTSQLInput stream, IfxResultSetMetaData metaData, Integer index) throws SQLException {
        int length = stream.readInt();
        ByteBuffer bb = ByteBuffer.allocate(length);
        byte[] bytes = stream.readBytes(length);
        bb.put(bytes);
        BasicBSONDecoder decoder = new BasicBSONDecoder();
        BSONObject bsonObject = decoder.readObject(bb.array());
        return new IfxBSONObject(bsonObject);
    }

    @Override
    public void write(IfmxUDTSQLOutput stream, IfxBSONObject value) throws SQLException {
        if (!(value instanceof BSONObject)) {
            throw new SQLException(MessageFormat.format("the value must be of type {0} (was {1})", BSONObject.class.getName(), value.getClass().getName()));
        }
        BasicBSONEncoder encoder = new BasicBSONEncoder();
        byte[] bytes = encoder.encode((BSONObject)value);
        stream.writeBytes(bytes, bytes.length);
    }

    @Override
    public String convertValueToString(Object value) {
        if (value == null) {
            return "null::bson";
        }
        if (value instanceof BSONObject) {
            return String.valueOf(JSONSerializers.getInformix().serialize(value)) + "::json::bson";
        }
        throw new IllegalArgumentException(MessageFormat.format("the value must be of type {0} (was {1})", BSONObject.class, value.getClass()));
    }

    @Override
    public IfxBSONObject convertValueTo(Object value) throws IllegalArgumentException {
        if (value instanceof IfxBSONObject) {
            return (IfxBSONObject)value;
        }
        if (value instanceof BSONObject) {
            return new IfxBSONObject((BSONObject)value);
        }
        throw new IllegalArgumentException(MessageFormat.format("the value must be of type {0} (was {1})", BSONObject.class, value.getClass()));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BsonTimeSeriesFieldDefinition []");
        return builder.toString();
    }

    public static BsonTimeSeriesFieldDefinition parseFieldDefinition(String s) {
        String trimmed = s.trim();
        if (trimmed.equalsIgnoreCase(TimeSeriesFieldType.BSON.getInformixTypeName())) {
            return new BsonTimeSeriesFieldDefinition();
        }
        throw new IllegalArgumentException();
    }

    public static class Factory
    implements TimeSeriesFieldDefinitionFactory<IfxBSONObject> {
        @Override
        public TimeSeriesFieldDefinition<IfxBSONObject> parse(String s) {
            return BsonTimeSeriesFieldDefinition.parseFieldDefinition(s);
        }
    }
}

