/*
 * Decompiled with CFR 0.152.
 */
package com.informix.timeseries.field.definition;

import com.informix.jdbc.IfmxUDTSQLInput;
import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.timeseries.field.definition.AbstractInformixFieldDefinition;
import com.informix.timeseries.field.definition.ObjectConversionUtilities;
import com.informix.timeseries.field.definition.TimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.TimeSeriesFieldDefinitionFactory;
import com.informix.timeseries.field.definition.TimeSeriesFieldType;
import java.sql.SQLException;
import java.text.MessageFormat;

public class BooleanTimeSeriesFieldDefinition
extends AbstractInformixFieldDefinition<Boolean>
implements TimeSeriesFieldDefinition<Boolean> {
    public BooleanTimeSeriesFieldDefinition() {
        super(TimeSeriesFieldType.BOOLEAN);
    }

    public static BooleanTimeSeriesFieldDefinition parseFieldDefinition(String s) {
        String trimmed = s.trim();
        if (trimmed.equalsIgnoreCase(TimeSeriesFieldType.BOOLEAN.getInformixTypeName())) {
            return new BooleanTimeSeriesFieldDefinition();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Boolean read(IfmxUDTSQLInput stream, IfxResultSetMetaData metaData, Integer index) throws SQLException {
        return stream.readBoolean();
    }

    @Override
    public void write(IfmxUDTSQLOutput stream, Boolean value) throws SQLException {
        stream.writeBoolean(value);
    }

    @Override
    public String convertValueToString(Object value) {
        if (value == null) {
            return "null::boolean";
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            if (b.booleanValue()) {
                return "'t'::boolean";
            }
            return "'f'::boolean";
        }
        throw new IllegalArgumentException(MessageFormat.format("the value must be of type {0} (was {1})", Boolean.class, value.getClass()));
    }

    @Override
    public Boolean convertValueTo(Object value) throws IllegalArgumentException {
        return ObjectConversionUtilities.convertObjectToBoolean(value);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BooleanTimeSeriesFieldDefinition []");
        return builder.toString();
    }

    public static class Factory
    implements TimeSeriesFieldDefinitionFactory<Boolean> {
        @Override
        public TimeSeriesFieldDefinition<Boolean> parse(String s) {
            return BooleanTimeSeriesFieldDefinition.parseFieldDefinition(s);
        }
    }
}

